/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.AttributeModifiersValue;
import org.confluence.terra_curio.api.primitive.ComponentsValue;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.init.TCDataComponentTypes;
import org.confluence.terra_curio.common.init.TCDataMaps;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.mixed.ILivingEntity;
import org.confluence.terra_curio.util.CuriosUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BaseCurioItem
extends Item
implements ICurioItem {
    protected static final ImmutableMultimap<Holder<Attribute>, AttributeModifier> EMPTY_ATTRIBUTE = ImmutableMultimap.of();
    protected Builder builder;

    public BaseCurioItem(Builder builder) {
        super(builder.initialize().properties);
        this.builder = builder;
    }

    public BaseCurioItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (this.builder == null || this.builder.particle == null) {
            return;
        }
        LivingEntity living = slotContext.entity();
        if (living.level().isClientSide) {
            ILivingEntity iLiving = (ILivingEntity)living;
            ParticleEmitter emitter = iLiving.terra_curio$getOrCreateParticleEmitters().get(this.builder.particle);
            if (emitter == null) {
                Map<ResourceLocation, ParticleEmitter> emitters = iLiving.terra_curio$getOrCreateParticleEmitters();
                emitter = new ParticleEmitter(living.level(), living.position(), this.builder.particle);
                emitter.attached = living;
                PSGameClient.LOADER.addEmitter(emitter, false);
                emitters.put(this.builder.particle, emitter);
            }
            this.particleTick(living, emitter, this.builder.particle);
            emitter.active &= slotContext.visible();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void particleTick(LivingEntity living, ParticleEmitter emitter, ResourceLocation particle) {
        if (emitter.isRemoved()) {
            ((ILivingEntity)living).terra_curio$getOrCreateParticleEmitters().remove(particle);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        AttributeModifiersValue value;
        AccessoriesComponent component = (AccessoriesComponent)stack.getItemHolder().getData(TCDataMaps.ACCESSORIES);
        if (component != null && (value = component.get(TCItems.ATTRIBUTES)) != null) {
            return value.get();
        }
        return this.builder == null ? EMPTY_ATTRIBUTE : this.builder.attributes;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        boolean b;
        ComponentsValue value;
        AccessoriesComponent component = (AccessoriesComponent)stack.getItemHolder().getData(TCDataMaps.ACCESSORIES);
        if (component != null && (value = component.get(TCItems.COMPONENTS)) != null) {
            tooltipComponents.addAll(value.components());
            return;
        }
        boolean bl = b = this.builder == null;
        if (b || this.builder.hasToolTip) {
            tooltipComponents.add((Component)Component.translatable((String)("tooltip." + stack.getDescriptionId() + ".0")));
            if (!b) {
                tooltipComponents.addAll(this.builder.additionTip);
            }
        }
    }

    public int getJeiInformationCount() {
        return this.builder == null ? 0 : this.builder.jeiInformationCount;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return this.canEquip(slotContext, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return slotContext.cosmetic() || CuriosUtils.noSameCurio(slotContext.entity(), this);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return this.builder != null && this.builder.makePiglinsNeutral;
    }

    public static Builder builder(String name, Item.Properties properties) {
        return new Builder(name, properties);
    }

    public static Builder builder(String name) {
        return new Builder(name, new Item.Properties());
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(EnchantmentTags.CURSE) || stack.is(((Enchantment)enchantment.value()).definition().supportedItems());
    }

    public static class Builder {
        private final String name;
        private final Item.Properties properties;
        private final ResourceLocation defaultId;
        private final List<Component> additionTip = new ArrayList<Component>();
        private boolean hasToolTip = true;
        private transient ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier> attributesBuilder = ImmutableMultimap.builder();
        private ImmutableMultimap<Holder<Attribute>, AttributeModifier> attributes;
        private ModRarity rarity = ModRarity.BLUE;
        private int jeiInformationCount = 1;
        private boolean makePiglinsNeutral = false;
        private EquipmentSlot equipmentSlot = null;
        private ResourceLocation particle = null;

        Builder(String name, Item.Properties properties) {
            this.name = name;
            this.properties = properties;
            this.defaultId = TerraCurio.asResource(name);
        }

        public Builder particle(ResourceLocation particle) {
            this.particle = particle;
            return this;
        }

        public Builder equipable(EquipmentSlot slot) {
            this.equipmentSlot = slot;
            return this;
        }

        public Builder makesPiglinsNeutral() {
            this.makePiglinsNeutral = true;
            return this;
        }

        public <T> Builder component(Supplier<DataComponentType<T>> type, T value) {
            this.properties.component(type, value);
            return this;
        }

        public Builder attribute(Holder<Attribute> attribute, String path, double amount, AttributeModifier.Operation operation) {
            this.attributesBuilder.put(attribute, (Object)new AttributeModifier(TerraCurio.asResource(this.name + "_" + path), amount, operation));
            return this;
        }

        public Builder attribute(Holder<Attribute> attribute, double amount, AttributeModifier.Operation operation) {
            this.attributesBuilder.put(attribute, (Object)new AttributeModifier(this.defaultId, amount, operation));
            return this;
        }

        public Builder rarity(ModRarity rarity) {
            this.rarity = rarity;
            if (rarity != ModRarity.GRAY && rarity != ModRarity.WHITE) {
                this.properties.fireResistant();
            }
            return this;
        }

        public Builder accessories(AccessoriesComponent component, AccessoriesComponent ... components) {
            if (components.length == 0) {
                this.properties.component(TCDataComponentTypes.ACCESSORIES, (Object)component);
            } else {
                Hashtable map = new Hashtable(component.types());
                for (AccessoriesComponent component1 : components) {
                    map.putAll(component1.types());
                }
                this.properties.component(TCDataComponentTypes.ACCESSORIES, (Object)new AccessoriesComponent(map));
            }
            return this;
        }

        public Builder tooltip(String str) {
            if (!this.hasToolTip) {
                throw new IllegalArgumentException("Can not add tooltip when noTooltip() invoked!");
            }
            this.additionTip.add((Component)Component.translatable((String)str));
            return this;
        }

        public Builder tooltips(int extra) {
            if (!this.hasToolTip) {
                throw new IllegalArgumentException("Can not add tooltip when noTooltip() invoked!");
            }
            ++extra;
            for (int i = 1; i < extra; ++i) {
                this.additionTip.add((Component)Component.translatable((String)("tooltip.item.terra_curio." + this.name + "." + i)));
            }
            return this;
        }

        public Builder jeiInfos(int count) {
            this.jeiInformationCount = count;
            return this;
        }

        public Builder noTooltip() {
            this.additionTip.clear();
            this.hasToolTip = false;
            return this;
        }

        @ApiStatus.Internal
        public Builder initialize() {
            this.properties.stacksTo(1).component(ConfluenceMagicLib.MOD_RARITY, (Object)this.rarity);
            this.attributes = this.attributesBuilder.build();
            this.attributesBuilder = null;
            return this;
        }

        @ApiStatus.Internal
        public ImmutableMultimap<Holder<Attribute>, AttributeModifier> getAttributes() {
            return this.attributes;
        }

        @ApiStatus.Internal
        @Nullable
        public ResourceLocation getParticle() {
            return this.particle;
        }

        public BaseCurioItem build() {
            if (this.equipmentSlot != null) {
                return new Equipable(this);
            }
            return new BaseCurioItem(this);
        }
    }

    public static class Equipable
    extends BaseCurioItem
    implements net.minecraft.world.item.Equipable {
        public Equipable(Builder builder) {
            super(builder);
        }

        public EquipmentSlot getEquipmentSlot() {
            return this.builder.equipmentSlot;
        }
    }
}

