/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio;

import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.fml.ModList;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;

public class RequiresModLoadedCurioItem
extends BaseCurioItem {
    private final String[] required;
    private final boolean noneLoaded;

    public RequiresModLoadedCurioItem(BaseCurioItem.Builder builder, String ... required) {
        super(builder);
        this.required = required;
        this.noneLoaded = Arrays.stream(required).noneMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
    }

    public RequiresModLoadedCurioItem(Item.Properties properties, String ... required) {
        super(properties);
        this.required = required;
        this.noneLoaded = Arrays.stream(required).noneMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.noneLoaded) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.terra_curio.requires_mod_loaded", (Object[])new Object[]{Arrays.toString(this.required)}));
        }
    }
}

