/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio.combat;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.confluence.terra_curio.common.init.TCEffects;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.util.CuriosUtils;
import top.theillusivec4.curios.api.SlotContext;

public class PaladinsShield
extends BaseCurioItem {
    public PaladinsShield(BaseCurioItem.Builder builder) {
        super(builder);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)livingEntity).level().getGameTime() % 200L == 0L) {
            PlayerTeam team = serverPlayer.getTeam();
            for (Player player : serverPlayer.level().players()) {
                if (player.getTeam() != team) continue;
                player.addEffect(new MobEffectInstance(TCEffects.PALADINS_SHIELD, 600, player == serverPlayer ? 1 : 0));
            }
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return CuriosUtils.noSameCurio(entity, PaladinsShield.class);
    }

    public static float apply(LivingEntity living, DamageSource damageSource, float amount) {
        ServerPlayer serverPlayer;
        if (living instanceof ServerPlayer && !PaladinsShield.isOwner((LivingEntity)(serverPlayer = (ServerPlayer)living))) {
            MutableFloat atomic = new MutableFloat(amount);
            PlayerTeam team = serverPlayer.getTeam();
            serverPlayer.level().players().stream().filter(arg_0 -> PaladinsShield.lambda$apply$0(serverPlayer, damageSource, (Team)team, arg_0)).min((playerA, playerB) -> (int)(playerA.distanceToSqr((Entity)serverPlayer) - playerB.distanceToSqr((Entity)serverPlayer))).ifPresent(player -> {
                float damage = amount * 0.25f;
                player.hurt(living.damageSources().playerAttack((Player)serverPlayer), damage);
                atomic.subtract(damage);
            });
            return atomic.getValue().floatValue();
        }
        return amount;
    }

    public static boolean isOwner(LivingEntity living) {
        MobEffectInstance effect = living.getEffect(TCEffects.PALADINS_SHIELD);
        return effect != null && effect.getAmplifier() != 0;
    }

    private static /* synthetic */ boolean lambda$apply$0(ServerPlayer serverPlayer, DamageSource damageSource, Team team, Player player) {
        return player != serverPlayer && player != damageSource.getEntity() && player.getTeam() == team && player.getHealth() / player.getMaxHealth() > 0.25f && PaladinsShield.isOwner((LivingEntity)player) && player.distanceToSqr((Entity)serverPlayer) < 1024.0;
    }
}

