/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio.combat;

import com.google.common.collect.Multimap;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.common.attachment.AccessoriesAttachment;
import org.confluence.terra_curio.common.init.TCAttachments;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.util.CuriosUtils;
import top.theillusivec4.curios.api.SlotContext;

public class PanicNecklace
extends BaseCurioItem {
    public static final String KEY = "terra_curio:last_hurt";

    public PanicNecklace(BaseCurioItem.Builder builder) {
        super(builder);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        CompoundTag nbt = LibUtils.getOrCreatePersistedData((Player)player);
        long lastHurt = nbt.getLong(KEY);
        if (lastHurt == 0L) {
            return;
        }
        if (player.level().getGameTime() - lastHurt > 160L) {
            nbt.putLong(KEY, 0L);
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return EMPTY_ATTRIBUTE;
        }
        Player player = (Player)livingEntity;
        return LibUtils.getOrCreatePersistedData((Player)player).getLong(KEY) == 0L ? EMPTY_ATTRIBUTE : super.getAttributeModifiers(slotContext, id, stack);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return CuriosUtils.noSameCurio(entity, PanicNecklace.class);
    }

    public static void apply(LivingEntity living) {
        Player player;
        if (living instanceof Player && ((AccessoriesAttachment)(player = (Player)living).getData(TCAttachments.ACCESSORIES)).hasPanicNecklace()) {
            LibUtils.getOrCreatePersistedData((Player)player).putLong(KEY, player.level().getGameTime());
        }
    }
}

