/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio.master;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.client.TCClientConfigs;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;
import org.confluence.terra_curio.common.init.TCSoundEvents;
import org.confluence.terra_curio.common.item.curio.movement.BaseSpeedBoots;
import org.confluence.terra_curio.network.c2s.SpeedBootsNBTPacketC2S;
import top.theillusivec4.curios.api.SlotContext;

public class BasePoint
extends BaseSpeedBoots {
    public BasePoint() {
        super(2, 80, BasePoint.builder("base_point").rarity(ModRarity.MASTER));
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        if (living.getBlockStateOn().is(BlockTags.SAND)) {
            this.speedUp(slotContext, stack, 4, 140);
        } else {
            this.speedUp(slotContext, stack, 2, 80);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void speedUp(SlotContext slotContext, ItemStack stack, int acceleration, int maxSpeed) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).isLocalPlayer()) return;
        int speed = LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt("terra_curio:boots_speed");
        if (player.zza != 0.0f || player.xxa != 0.0f) {
            if (TCClientPacketHandler.isHasMagiluminescence()) {
                acceleration *= 3;
            }
            int actually = Math.min(maxSpeed - speed, acceleration);
            int value = speed + actually;
            if (actually > 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SpeedBootsNBTPacketC2S(slotContext.index(), value), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (player.onGround()) {
                float ratio = (float)value / (float)maxSpeed;
                if (TCClientConfigs.playShoesSound && player.level().getGameTime() % (ratio < 0.5f ? 6L : 4L) == 0L) {
                    player.playSound(TCSoundEvents.SHOES_WALK.get());
                }
            }
            if (!TCClientConfigs.showShoesParticle) return;
        }
        if (speed == 0) return;
        PacketDistributor.sendToServer((CustomPacketPayload)new SpeedBootsNBTPacketC2S(slotContext.index(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

