/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio.movement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.AttributeModifiersValue;
import org.confluence.terra_curio.client.TCClientConfigs;
import org.confluence.terra_curio.client.handler.GravitationHandler;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.init.TCDataMaps;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCSoundEvents;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.network.c2s.SpeedBootsNBTPacketC2S;
import org.confluence.terra_curio.util.CuriosUtils;
import org.joml.Vector3f;
import org.mesdag.particlestorm.particle.ParticleEmitter;
import top.theillusivec4.curios.api.SlotContext;

public class BaseSpeedBoots
extends BaseCurioItem {
    public static final String KEY = "terra_curio:boots_speed";
    public static final ResourceLocation ID = TerraCurio.asResource("base_speed_boots");
    private final int acceleration;
    private final int maxSpeed;

    public BaseSpeedBoots(int acceleration, int maxSpeed, BaseCurioItem.Builder builder) {
        super(builder);
        this.acceleration = acceleration;
        this.maxSpeed = maxSpeed;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        this.speedUp(slotContext, stack, this.acceleration, this.maxSpeed);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void particleTick(LivingEntity living, ParticleEmitter emitter, ResourceLocation particle) {
        if (GravitationHandler.isShouldRot() && living.getClass() == LocalPlayer.class) {
            emitter.active = false;
        } else {
            emitter.offsetPos = new Vec3(0.0, 0.0, (double)living.zza * 0.5);
            if (emitter.parentRotation == null) {
                emitter.parentRotation = new Vector3f();
            }
            emitter.active = living.zza > 0.0f && !living.horizontalCollision;
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LibUtils.updateItemStackNbt((ItemStack)stack, tag -> tag.putInt(KEY, 0));
    }

    protected void speedUp(SlotContext slotContext, ItemStack stack, int acceleration, int maxSpeed) {
        Player player;
        LivingEntity livingEntity;
        LibUtils.forMixin$Inject();
        if (TCClientConfigs.speedUp && (livingEntity = slotContext.entity()) instanceof Player && (player = (Player)livingEntity).isLocalPlayer()) {
            int speed = LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt(KEY);
            if (player.zza > 0.0f && !player.horizontalCollision && !player.isCrouching()) {
                if (player.onGround()) {
                    if (TCClientPacketHandler.isHasMagiluminescence() || PlayerJumpHandler.isInfiniteFlight()) {
                        acceleration *= 2;
                    }
                    int actually = Math.min(maxSpeed - speed, acceleration);
                    int value = speed + actually;
                    if (actually > 0) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new SpeedBootsNBTPacketC2S(slotContext.index(), value), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    float ratio = (float)value / (float)maxSpeed;
                    if (TCClientConfigs.playShoesSound && player.level().getGameTime() % (ratio < 0.5f ? 6L : 4L) == 0L) {
                        player.playSound(TCSoundEvents.SHOES_WALK.get(), TCClientConfigs.shoesSoundVolume, 1.0f);
                    }
                }
                if (TCClientConfigs.showShoesParticle) {
                    // empty if block
                }
            } else if (speed != 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SpeedBootsNBTPacketC2S(slotContext.index(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        double speed;
        AttributeModifiersValue value;
        ImmutableMultimap.Builder builder1 = ImmutableMultimap.builder();
        builder1.putAll(this.builder.getAttributes());
        AccessoriesComponent component = (AccessoriesComponent)stack.getItemHolder().getData(TCDataMaps.ACCESSORIES);
        if (component != null && (value = component.get(TCItems.ATTRIBUTES)) != null) {
            builder1.putAll(value.get());
        }
        if ((speed = (double)LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt(KEY) * 0.01) > 0.0) {
            builder1.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ID, speed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        return builder1.build();
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosUtils.noSameCurio(slotContext.entity(), BaseSpeedBoots.class);
    }
}

