/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item.curio.movement;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.common.entity.StepStoolEntity;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.network.s2c.StepStoolSteppingPacketS2C;
import org.confluence.terra_curio.util.CuriosUtils;
import top.theillusivec4.curios.api.SlotContext;

public class StepStool
extends BaseCurioItem {
    public StepStool(BaseCurioItem.Builder builder) {
        super(builder);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (prevStack.getItem() == stack.getItem()) {
            return;
        }
        super.onEquip(slotContext, prevStack, stack);
        if (!slotContext.entity().level().isClientSide) {
            StepStoolSteppingPacketS2C.sendToClient(slotContext, LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt("extraStep") + 1);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (newStack.getItem() == stack.getItem()) {
            return;
        }
        super.onUnequip(slotContext, newStack, stack);
        Level level = slotContext.entity().level();
        if (!level.isClientSide) {
            StepStoolSteppingPacketS2C.resetStep((Entity)slotContext.entity());
            Entity entity = level.getEntity(LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt("id"));
            if (entity instanceof StepStoolEntity) {
                StepStoolEntity stepStool = (StepStoolEntity)entity;
                stepStool.setOwner(null);
            }
        }
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosUtils.noSameCurio(slotContext.entity(), StepStool.class);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.terra_curio.step_stool.1", (Object[])new Object[]{LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getInt("extraStep")}).withStyle(style -> style.withColor(ChatFormatting.BLUE)));
    }
}

