/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.menu;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.common.menu.AmountResultSlot;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.MenuRecipeInput;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.common.init.TCBlocks;
import org.confluence.terra_curio.common.init.TCMenus;
import org.confluence.terra_curio.common.init.TCRecipes;
import org.confluence.terra_curio.common.recipe.WorkshopRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkshopMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Player player;
    private final MenuRecipeInput input;
    private final ResultContainer result;
    private final AmountResultSlot<WorkshopRecipe> resultSlot;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private List<RecipeHolder<WorkshopRecipe>> recipes = new ArrayList<RecipeHolder<WorkshopRecipe>>();

    public WorkshopMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.NULL);
    }

    public WorkshopMenu(int containerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(TCMenus.WORKSHOP.get(), containerId);
        this.player = pPlayerInventory.player;
        this.access = (ContainerLevelAccess)LibUtils.forMixin$ModifyExpression((Object)pAccess);
        this.input = (MenuRecipeInput)LibUtils.forMixin$ModifyExpression((Object)new MenuRecipeInput((AbstractContainerMenu)this, 12));
        this.result = new ResultContainer();
        this.resultSlot = new AmountResultSlot<WorkshopRecipe>(this.input, (Container)this.result, 0, 62, 35){

            protected void updateMenu() {
                WorkshopMenu.this.setupResultSlot();
            }
        };
        this.addSlot((Slot)this.resultSlot);
        this.addSlot(new Slot((Container)this.input, 0, 35, 8));
        this.addSlot(new Slot((Container)this.input, 1, 53, 8));
        this.addSlot(new Slot((Container)this.input, 2, 71, 8));
        this.addSlot(new Slot((Container)this.input, 3, 89, 8));
        this.addSlot(new Slot((Container)this.input, 4, 89, 26));
        this.addSlot(new Slot((Container)this.input, 5, 89, 44));
        this.addSlot(new Slot((Container)this.input, 6, 89, 62));
        this.addSlot(new Slot((Container)this.input, 7, 71, 62));
        this.addSlot(new Slot((Container)this.input, 8, 53, 62));
        this.addSlot(new Slot((Container)this.input, 9, 35, 62));
        this.addSlot(new Slot((Container)this.input, 10, 35, 44));
        this.addSlot(new Slot((Container)this.input, 11, 35, 26));
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)pPlayerInventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)pPlayerInventory, m, 8 + m * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getCurrentIndex() {
        return this.selectedRecipeIndex.get();
    }

    public int getRecipesAmount() {
        return this.recipes.size();
    }

    public ItemStack getUpResult() {
        int index = this.getUpIndex();
        if (index == -1) {
            return this.result.getItem(0);
        }
        return ((WorkshopRecipe)this.recipes.get(index).value()).getResultItem(null);
    }

    public int getUpIndex() {
        if (this.recipes.isEmpty()) {
            return -1;
        }
        if (this.recipes.size() == 1) {
            return 0;
        }
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            if (this.selectedRecipeIndex.get() == 0) {
                return this.recipes.size() - 1;
            }
            return this.selectedRecipeIndex.get() - 1;
        }
        return -1;
    }

    public ItemStack getDownResult() {
        int index = this.getDownIndex();
        if (index == -1) {
            return this.result.getItem(0);
        }
        return ((WorkshopRecipe)this.recipes.get(index).value()).getResultItem(null);
    }

    public int getDownIndex() {
        if (this.recipes.isEmpty()) {
            return -1;
        }
        if (this.recipes.size() == 1) {
            return 0;
        }
        if (this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            int next = this.selectedRecipeIndex.get() + 1;
            if (next == this.recipes.size()) {
                return 0;
            }
            return next;
        }
        return -1;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.set(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            WorkshopRecipe recipe = (WorkshopRecipe)this.recipes.get(this.selectedRecipeIndex.get()).value();
            ItemStack itemStack = recipe.getResultItem(null).copy();
            if (itemStack.isItemEnabled(this.player.level().enabledFeatures())) {
                this.result.setItem(0, itemStack);
                this.resultSlot.setCurrentRecipe((AbstractAmountRecipe)recipe);
            } else {
                this.result.setItem(0, ItemStack.EMPTY);
            }
        } else {
            this.result.setItem(0, ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public boolean stillValid(Player pPlayer) {
        return WorkshopMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)TCBlocks.WORKSHOP.get()));
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((level, blockPos) -> this.clearContainer(pPlayer, (Container)this.input));
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.result && super.canTakeItemForPickAll(pStack, pSlot);
    }

    public void slotsChanged(Container pContainer) {
        this.recipes = this.player.level().getRecipeManager().getRecipesFor(TCRecipes.WORKSHOP_TYPE.get(), (RecipeInput)this.input, this.player.level());
        if (this.selectedRecipeIndex.get() >= this.recipes.size()) {
            this.selectedRecipeIndex.set(this.recipes.size() - 1);
        }
        this.access.execute((level, pos) -> {
            Player patt0$temp = this.player;
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack itemStack = ItemStack.EMPTY;
                if (!this.recipes.isEmpty()) {
                    if (this.selectedRecipeIndex.get() == -1) {
                        this.selectedRecipeIndex.set(0);
                    }
                    WorkshopRecipe recipe = (WorkshopRecipe)this.recipes.get(this.selectedRecipeIndex.get()).value();
                    itemStack = recipe.getResultItem(null).copy();
                    this.resultSlot.setCurrentRecipe((AbstractAmountRecipe)recipe);
                }
                this.result.setItem(0, itemStack);
                this.setRemoteSlot(0, itemStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            }
        });
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemStack = slotItem.copy();
            if (pIndex == 0) {
                this.access.execute((level, blockPos) -> slotItem.getItem().onCraftedBy(slotItem, level, pPlayer));
                if (!this.moveItemStackTo(slotItem, 13, 49, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItem, itemStack);
            } else if (pIndex >= 13 && pIndex < 49 ? !this.moveItemStackTo(slotItem, 1, 13, false) && (pIndex < 40 ? !this.moveItemStackTo(slotItem, 40, 49, false) : !this.moveItemStackTo(slotItem, 13, 40, false)) : !this.moveItemStackTo(slotItem, 13, 49, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotItem);
            if (pIndex == 0) {
                pPlayer.drop(slotItem, false);
            }
        }
        return itemStack;
    }
}

