/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.common.item.curio.movement.StepStool;
import org.confluence.terra_curio.mixin.accessor.SmithingTransformRecipeAccessor;

public class ExtraStepStoolRecipe
extends SmithingTransformRecipe {
    public ExtraStepStoolRecipe(Ingredient base, Ingredient addition, ItemStack result) {
        super(Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TCItems.STEP_STOOL.get(), (ItemLike)TCItems.HAND_OF_CREATION.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TCItems.STEP_STOOL.get()}), ((BaseCurioItem)((Object)TCItems.STEP_STOOL.get())).getDefaultInstance());
    }

    public boolean matches(SmithingRecipeInput input, Level level) {
        ItemStack base = input.getItem(1);
        ItemStack addition = input.getItem(2);
        if (this.isBaseIngredient(base) && this.isAdditionIngredient(addition)) {
            CompoundTag tag = LibUtils.getItemStackNbtNoCopy((ItemStack)base);
            return tag.getInt("extraStep") + tag.getInt("extraStep") < 15;
        }
        return false;
    }

    public boolean isBaseIngredient(ItemStack pStack) {
        return pStack.getItem() instanceof StepStool && LibUtils.getItemStackNbtNoCopy((ItemStack)pStack).getInt("extraStep") < 15;
    }

    public boolean isIncomplete() {
        return false;
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        ItemStack base = input.getItem(1).copyWithCount(1);
        int additional = LibUtils.getItemStackNbtNoCopy((ItemStack)input.getItem(2)).getInt("extraStep");
        LibUtils.updateItemStackNbt((ItemStack)base, nbt -> nbt.putInt("extraStep", nbt.getInt("extraStep") + additional + 1));
        return base;
    }

    public static class Serializer
    implements RecipeSerializer<ExtraStepStoolRecipe> {
        public static final MapCodec<ExtraStepStoolRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> ((SmithingTransformRecipeAccessor)((Object)recipe)).getBase()), (App)Ingredient.CODEC.fieldOf("addition").forGetter(recipe -> ((SmithingTransformRecipeAccessor)((Object)recipe)).getAddition()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> ((SmithingTransformRecipeAccessor)((Object)recipe)).getResult())).apply((Applicative)instance, ExtraStepStoolRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ExtraStepStoolRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ExtraStepStoolRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ExtraStepStoolRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ExtraStepStoolRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new ExtraStepStoolRecipe(ingredient1, ingredient2, itemstack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ExtraStepStoolRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((SmithingTransformRecipeAccessor)((Object)recipe)).getBase());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((SmithingTransformRecipeAccessor)((Object)recipe)).getAddition());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((SmithingTransformRecipeAccessor)((Object)recipe)).getResult());
        }
    }
}

