/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.integration.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCRecipes;
import org.confluence.terra_curio.common.item.DemonHeart;
import org.confluence.terra_curio.common.item.DivingHelmet;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.integration.jei.WorkshopCategory;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public final class ModJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = TerraCurio.asResource("jei_plugin");
    public static final ResourceLocation ARROW_RIGHT = TerraCurio.asResource("textures/gui/arrow_right.png");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkshopCategory(jeiHelpers)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level;
        if (!((Boolean)ConfluenceMagicLib.IS_CONFLUENCE_LOADED.get()).booleanValue()) {
            registration.addItemStackInfo(((DemonHeart)((Object)TCItems.DEMON_HEART.get())).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.tooltip.item.terra_curio.demon_heart.0")});
            registration.addItemStackInfo(((DivingHelmet)((Object)TCItems.DIVING_HELMET.get())).getDefaultInstance(), new Component[]{Component.translatable((String)"jei.tooltip.item.terra_curio.diving_helmet.0"), Component.translatable((String)"jei.tooltip.item.terra_curio.diving_helmet.1")});
            TCItems.CURIOS.getEntries().forEach(entry -> {
                BaseCurioItem curioItem;
                Object patt0$temp = entry.get();
                if (patt0$temp instanceof BaseCurioItem && (curioItem = (BaseCurioItem)((Object)((Object)patt0$temp))).getJeiInformationCount() > 0) {
                    Component[] information = new Component[curioItem.getJeiInformationCount()];
                    for (int i = 0; i < information.length; ++i) {
                        information[i] = Component.translatable((String)("jei.tooltip." + curioItem.getDescriptionId() + "." + i));
                    }
                    registration.addItemStackInfo(((Item)entry.get()).getDefaultInstance(), information);
                }
            });
        }
        if ((level = Minecraft.getInstance().level) == null) {
            return;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        registration.addRecipes(WorkshopCategory.TYPE, recipeManager.getAllRecipesFor(TCRecipes.WORKSHOP_TYPE.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((BlockItem)TCItems.WORKSHOP.get()).getDefaultInstance(), new RecipeType[]{WorkshopCategory.TYPE});
    }

    public static void drawArrowRight(GuiGraphics guiGraphics, int x, int y, boolean usable) {
        guiGraphics.blit(ARROW_RIGHT, x, y, 0.0f, usable ? 0.0f : 21.0f, 28, 21, 42, 42);
    }

    public static void addInput(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        if (!ingredient.isEmpty()) {
            ICustomIngredient iCustomIngredient = ingredient.getCustomIngredient();
            if (iCustomIngredient instanceof AmountIngredient) {
                AmountIngredient amountIngredient = (AmountIngredient)iCustomIngredient;
                builder.addInputSlot(x, y).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, amountIngredient.getItems().toList());
            } else {
                builder.addInputSlot(x, y).addIngredients(ingredient);
            }
        }
    }
}

