/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.integration.jei;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.recipe.WorkshopRecipe;
import org.confluence.terra_curio.integration.jei.ModJeiPlugin;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkshopCategory
implements IRecipeCategory<RecipeHolder<WorkshopRecipe>> {
    public static final RecipeType<RecipeHolder<WorkshopRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)TerraCurio.asResource("workshop"));
    private static final Component TITLE = Component.translatable((String)"title.terra_curio.workshop");
    private final IDrawable icon;

    public WorkshopCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)TCItems.WORKSHOP.get()));
    }

    public RecipeType<RecipeHolder<WorkshopRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public int getWidth() {
        return 128;
    }

    public int getHeight() {
        return 64;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<WorkshopRecipe> recipe, IFocusGroup focusGroup) {
        int size = ((WorkshopRecipe)recipe.value()).getIngredients().size();
        int line = size / 3;
        boolean remain = size % 3 != 0;
        int x = 0;
        int y = 0;
        if (line == 0) {
            y = 24;
        } else if (line == 1) {
            y = remain ? 16 : 24;
        } else if (line == 2) {
            y = remain ? 8 : 16;
        } else if (line == 3) {
            y = remain ? 0 : 8;
        }
        for (Ingredient ingredient : ((WorkshopRecipe)recipe.value()).getIngredients()) {
            ModJeiPlugin.addInput(builder, x, y, ingredient);
            if ((x += 16) != 48) continue;
            x = 0;
            y += 16;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 24).addItemStack(((WorkshopRecipe)recipe.value()).getResultItem(null));
    }

    public void draw(RecipeHolder<WorkshopRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ModJeiPlugin.drawArrowRight(guiGraphics, 50, 22, true);
    }
}

