/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.confluence.lib.mixed.SelfGetter;
import org.confluence.terra_curio.mixed.IEntity;
import org.confluence.terra_curio.util.TCUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntity,
SelfGetter<Entity> {
    @Shadow
    public float fallDistance;
    @Shadow
    private Level level;
    @Unique
    private int terra_curio$cthulhuSprintingTime = 0;
    @Unique
    private boolean terra_curio$isShouldRot = false;
    @Unique
    private float terra_curio$dimensionHeight = 0.0f;

    @Shadow
    public abstract DamageSources damageSources();

    @Shadow
    protected abstract BlockPos getOnPos(float var1);

    @Shadow
    public abstract EntityDimensions getDimensions(Pose var1);

    @Shadow
    public abstract Pose getPose();

    @Override
    public int terra_curio$getCthulhuSprintingTime() {
        return this.terra_curio$cthulhuSprintingTime;
    }

    @Override
    public void terra_curio$setCthulhuSprintingTime(int amount) {
        this.terra_curio$cthulhuSprintingTime = amount;
    }

    @Override
    public void terra_curio$setShouldRot(boolean bool) {
        this.terra_curio$isShouldRot = bool;
    }

    @Override
    public boolean terra_curio$isShouldRot() {
        return this.terra_curio$isShouldRot;
    }

    @Override
    public float terra_curio$getDimensionHeight() {
        return this.terra_curio$dimensionHeight;
    }

    @ModifyExpressionValue(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInLava()Z", ordinal=1)})
    private boolean resetLavaImmune(boolean original) {
        Entity self = (Entity)this.confluence$self();
        if (self instanceof LivingEntity) {
            original = TCUtils.applyLavaImmune(original, self);
            this.terra_curio$dimensionHeight = this.terra_curio$isShouldRot ? this.getDimensions(this.getPose()).height() : 0.0f;
        }
        return original;
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void tickProfiler(CallbackInfo ci) {
        if (this.terra_curio$cthulhuSprintingTime > 0) {
            --this.terra_curio$cthulhuSprintingTime;
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void collidingCheck(Entity entity, CallbackInfo ci) {
        Object object = this.confluence$self();
        if (object instanceof Player) {
            Player player = (Player)object;
            TCUtils.applyCthulhuTouch(player, entity);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            TCUtils.applyCthulhuTouch(player, (Entity)this.confluence$self());
        }
    }

    @Inject(method={"getOnPosLegacy"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOnPosAbove(CallbackInfoReturnable<BlockPos> cir) {
        if (this.terra_curio$isShouldRot) {
            cir.setReturnValue((Object)this.getOnPos(-(this.terra_curio$dimensionHeight + 0.2f)));
        }
    }

    @WrapOperation(method={"checkSupportingBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;")})
    private AABB getBoundingBox(Entity instance, Operation<AABB> original) {
        AABB aabb = (AABB)original.call(new Object[]{instance});
        if (this.terra_curio$isShouldRot) {
            return new AABB(aabb.minX, aabb.maxY + (double)1.0E-5f, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
        }
        return aabb;
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="TAIL")})
    private void updateFallDIstance(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo ci) {
        if (this.terra_curio$isShouldRot && !this.level.isClientSide && y > 0.0) {
            this.fallDistance += (float)y;
        }
    }

    @ModifyArg(method={"spawnSprintParticle"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), index=2)
    private double modifyParticlePosY(double y) {
        if (this.terra_curio$isShouldRot) {
            return y - 0.2 + (double)this.terra_curio$dimensionHeight;
        }
        return y;
    }

    @ModifyArg(method={"spawnSprintParticle"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), index=5)
    private double modifyParticleSpeedY(double y) {
        return this.terra_curio$isShouldRot ? -y : y;
    }
}

