/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.InformationHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record InfoDisablePacket(boolean[] disables) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InfoDisablePacket> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("info_disable"));
    public static final StreamCodec<ByteBuf, InfoDisablePacket> STREAM_CODEC = new StreamCodec<ByteBuf, InfoDisablePacket>(){

        public InfoDisablePacket decode(ByteBuf buffer) {
            byte[] bytes = new byte[13];
            buffer.readBytes(bytes);
            boolean[] disables = new boolean[13];
            for (int i = 0; i < 13; ++i) {
                disables[i] = bytes[i] != 0;
            }
            return new InfoDisablePacket(disables);
        }

        public void encode(ByteBuf buffer, InfoDisablePacket value) {
            byte[] bytes = new byte[13];
            for (int i = 0; i < 13; ++i) {
                bytes[i] = (byte)(value.disables[i] ? 1 : 0);
            }
            buffer.writeBytes(bytes);
        }
    };

    public CustomPacketPayload.Type<InfoDisablePacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                System.arraycopy(this.disables, 0, InformationHandler.DISABLE, 0, 13);
            } else {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ByteArrayTag arrayTag = new ByteArrayTag(new byte[13]);
                    for (int i = 0; i < 13; ++i) {
                        arrayTag.set(i, ByteTag.valueOf((boolean)this.disables[i]));
                    }
                    LibUtils.getOrCreatePersistedData((Player)player).put("terra_curio:info_disable", (Tag)arrayTag);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(ServerPlayer player) {
        byte[] bytes = LibUtils.getOrCreatePersistedData((Player)player).getByteArray("terra_curio:info_disable");
        if (bytes.length != 13) {
            return;
        }
        boolean[] disables = new boolean[13];
        for (int i = 0; i < 13; ++i) {
            disables[i] = bytes[i] != 0;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new InfoDisablePacket(disables), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(boolean[] disables) {
        PacketDistributor.sendToServer((CustomPacketPayload)new InfoDisablePacket(disables), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

