/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.effect.GravitationEffect;
import org.confluence.terra_curio.mixed.IEntity;
import org.confluence.terra_curio.network.s2c.BroadcastGravitationRotPacketS2C;

public record GravitationPacketC2S(boolean enable) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GravitationPacketC2S> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("gravitation"));
    public static final StreamCodec<ByteBuf, GravitationPacketC2S> STREAM_CODEC = ByteBufCodecs.BOOL.map(GravitationPacketC2S::new, GravitationPacketC2S::enable);

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                serverPlayer.resetFallDistance();
                AttributeMap attributeMap = serverPlayer.getAttributes();
                if (this.enable) {
                    attributeMap.addTransientAttributeModifiers(GravitationEffect.GRAVITY);
                } else {
                    AttributeInstance attributeInstance = attributeMap.getInstance(Attributes.GRAVITY);
                    if (attributeInstance != null) {
                        attributeInstance.removeModifier(GravitationEffect.ID);
                    }
                }
                ((IEntity)serverPlayer).terra_curio$setShouldRot(this.enable);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BroadcastGravitationRotPacketS2C(serverPlayer.getId(), this.enable), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public CustomPacketPayload.Type<GravitationPacketC2S> type() {
        return TYPE;
    }
}

