/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;

public record PlayerJumpPacketC2S(byte jumpState, float motionY) implements CustomPacketPayload
{
    public static final byte JUMP_BY_SELF = 1;
    public static final byte RESET_FALL_DISTANCE = 2;
    public static final CustomPacketPayload.Type<PlayerJumpPacketC2S> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("player_jump_c2s"));
    public static final StreamCodec<ByteBuf, PlayerJumpPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, PlayerJumpPacketC2S::jumpState, (StreamCodec)ByteBufCodecs.FLOAT, PlayerJumpPacketC2S::motionY, PlayerJumpPacketC2S::new);

    public CustomPacketPayload.Type<PlayerJumpPacketC2S> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                serverPlayer.hasImpulse = true;
                if ((this.jumpState & 1) != 0) {
                    serverPlayer.awardStat(Stats.JUMP);
                    serverPlayer.causeFoodExhaustion(serverPlayer.isSprinting() ? 0.2f : 0.05f);
                }
                if ((this.jumpState & 2) != 0) {
                    serverPlayer.resetFallDistance();
                }
                Vec3 motion = serverPlayer.getDeltaMovement();
                serverPlayer.setDeltaMovement(motion.x, (double)this.motionY, motion.z);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

