/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.entity.XBoneProjectile;
import org.confluence.terra_curio.common.init.TCEntities;

public record ShootXBonePacketC2S() implements CustomPacketPayload
{
    public static final ShootXBonePacketC2S INSTANCE = new ShootXBonePacketC2S();
    public static final CustomPacketPayload.Type<ShootXBonePacketC2S> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("shoot_x_bone"));
    public static final StreamCodec<ByteBuf, ShootXBonePacketC2S> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<ShootXBonePacketC2S> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                long l = LibUtils.getOrCreatePersistedData((Player)player).getLong("terra_curio:last_x_bone");
                Level level = player.level();
                long gameTime = level.getGameTime();
                if (gameTime - l > 20L) {
                    LibUtils.getOrCreatePersistedData((Player)player).putLong("terra_curio:last_x_bone", gameTime);
                    XBoneProjectile projectile = new XBoneProjectile((EntityType<XBoneProjectile>)((EntityType)TCEntities.X_BONE.get()), level);
                    projectile.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
                    projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.2f, 0.0f);
                    projectile.setOwner((Entity)player);
                    level.addFreshEntity((Entity)projectile);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

