/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.c2s;

import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.item.curio.movement.BaseSpeedBoots;
import org.confluence.terra_curio.util.CuriosUtils;

public record SpeedBootsNBTPacketC2S(int slot, int value) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpeedBootsNBTPacketC2S> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("speed_boots_nbt"));
    public static final StreamCodec<ByteBuf, SpeedBootsNBTPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SpeedBootsNBTPacketC2S::slot, (StreamCodec)ByteBufCodecs.VAR_INT, SpeedBootsNBTPacketC2S::value, SpeedBootsNBTPacketC2S::new);
    private static final Predicate<ItemStack> PREDICATE = itemStack -> itemStack.getItem() instanceof BaseSpeedBoots;

    public CustomPacketPayload.Type<SpeedBootsNBTPacketC2S> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer;
            ItemStack itemStack;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (itemStack = CuriosUtils.getSlot((LivingEntity)(serverPlayer = (ServerPlayer)patt0$temp), PREDICATE, this.slot)) != null) {
                LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> nbt.putInt("terra_curio:boots_speed", this.value));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

