/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.c2s;

import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.entity.StepStoolEntity;
import org.confluence.terra_curio.common.item.curio.movement.StepStool;
import org.confluence.terra_curio.util.CuriosUtils;

public record StepStoolSteppingPacketC2S(int slot, byte step) implements CustomPacketPayload
{
    public static final byte STEP_MASK = 63;
    public static final byte INCREASE = 64;
    public static final CustomPacketPayload.Type<StepStoolSteppingPacketC2S> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("step_stool_stepping_c2s"));
    public static final StreamCodec<ByteBuf, StepStoolSteppingPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StepStoolSteppingPacketC2S::slot, (StreamCodec)ByteBufCodecs.BYTE, StepStoolSteppingPacketC2S::step, StepStoolSteppingPacketC2S::new);
    private static final Predicate<ItemStack> PREDICATE = itemStack -> itemStack.getItem() instanceof StepStool;

    public CustomPacketPayload.Type<StepStoolSteppingPacketC2S> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (this.slot == -1) {
                return;
            }
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                boolean increase;
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack itemStack = CuriosUtils.getSlot((LivingEntity)serverPlayer, PREDICATE, this.slot);
                if (itemStack == null) {
                    return;
                }
                int actualStep = this.step & 0x3F;
                boolean bl = increase = (this.step & 0x40) == 64;
                if (actualStep == 1 && increase) {
                    StepStoolEntity entity = new StepStoolEntity((Player)serverPlayer);
                    serverPlayer.level().addFreshEntity((Entity)entity);
                    serverPlayer.teleportRelative(0.0, 1.001, 0.0);
                    LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> nbt.putInt("id", entity.getId()));
                } else {
                    int id = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).getInt("id");
                    Entity entity = serverPlayer.level().getEntity(id);
                    if (entity instanceof StepStoolEntity) {
                        StepStoolEntity stepStool = (StepStoolEntity)entity;
                        if (actualStep == 0) {
                            stepStool.setOwner(null);
                        } else {
                            stepStool.setStep(actualStep);
                            if (increase) {
                                serverPlayer.teleportRelative(0.0, 1.001, 0.0);
                            }
                        }
                    }
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

