/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.util.TCUtils;

public record BroadcastRenderPacketS2C(int playerId, short render) implements CustomPacketPayload
{
    public static final short LUMINANCE_MASK = 15;
    public static final short NEPTUNES_SHELL = 16;
    public static final short MOON_CHARM = 32;
    public static final CustomPacketPayload.Type<BroadcastRenderPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("broadcast_render"));
    public static final StreamCodec<ByteBuf, BroadcastRenderPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, BroadcastRenderPacketS2C::playerId, (StreamCodec)ByteBufCodecs.SHORT, BroadcastRenderPacketS2C::render, BroadcastRenderPacketS2C::new);

    public CustomPacketPayload.Type<BroadcastRenderPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                TCClientPacketHandler.handleRender(this, context.player());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToAll(ServerPlayer serverPlayer) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            short luminance = (short)(TCUtils.getAccessoriesValue((LivingEntity)serverPlayer, TCItems.LUMINANCE) & 0xF);
            int neptunesShell = TCUtils.hasAccessoriesType((LivingEntity)serverPlayer, TCItems.NEPTUNES$SHELL) ? 16 : 0;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BroadcastRenderPacketS2C(serverPlayer.getId(), (short)(luminance | neptunesShell)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

