/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.InformationHandler;

public record EntityKilledPacketS2C(int amount, ResourceLocation entityType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EntityKilledPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("entity_killed"));
    public static final StreamCodec<ByteBuf, EntityKilledPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, EntityKilledPacketS2C::amount, (StreamCodec)ResourceLocation.STREAM_CODEC, EntityKilledPacketS2C::entityType, EntityKilledPacketS2C::new);

    public CustomPacketPayload.Type<EntityKilledPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                InformationHandler.handleEntityKilled(this);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(ServerPlayer serverPlayer, EntityType<?> entityType) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EntityKilledPacketS2C(serverPlayer.getStats().getValue(Stats.ENTITY_KILLED.get(entityType)), BuiltInRegistries.ENTITY_TYPE.getKey(entityType)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

