/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.util.TCUtils;

public record FluidWalkUpdatePacketS2C() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FluidWalkUpdatePacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("fluid_walk_update"));
    private static final FluidWalkUpdatePacketS2C INSTANCE = new FluidWalkUpdatePacketS2C();
    public static final StreamCodec<ByteBuf, FluidWalkUpdatePacketS2C> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<FluidWalkUpdatePacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                TCUtils.updateWalkableFluidStates(context.player());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(ServerPlayer serverPlayer) {
        TCUtils.updateWalkableFluidStates((Player)serverPlayer);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

