/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.util.TCUtils;

public record InfiniteFlightPacketS2C(boolean enable) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InfiniteFlightPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("infinite_flight"));
    public static final StreamCodec<ByteBuf, InfiniteFlightPacketS2C> STREAM_CODEC = ByteBufCodecs.BOOL.map(InfiniteFlightPacketS2C::new, InfiniteFlightPacketS2C::enable);

    public CustomPacketPayload.Type<InfiniteFlightPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                PlayerJumpHandler.handleInfiniteFlight(this);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(ServerPlayer serverPlayer) {
        boolean enable = TCUtils.hasAccessoriesType((LivingEntity)serverPlayer, TCItems.INFINITE$FLIGHT);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new InfiniteFlightPacketS2C(enable), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

