/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.TooltipComponentsValue;
import org.confluence.terra_curio.client.handler.InformationHandler;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.item.IFunctionCouldEnable;
import org.confluence.terra_curio.util.CuriosUtils;
import org.confluence.terra_curio.util.TCUtils;

public record InfoCurioCheckPacketS2C(int playerId, byte[] enabled) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InfoCurioCheckPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("info_curio_check"));
    public static final StreamCodec<ByteBuf, InfoCurioCheckPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, InfoCurioCheckPacketS2C::playerId, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, InfoCurioCheckPacketS2C::enabled, InfoCurioCheckPacketS2C::new);
    public static final int ARRAY_LENGTH = 13;
    public static final double MAX_SHARE_DISTANCE_SQR = 1024.0;

    public CustomPacketPayload.Type<InfoCurioCheckPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                InformationHandler.handlePacket(this, context.player());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    private static byte checkEnabled(byte original, byte target, ItemStack itemStack, TooltipComponentsValue.Storage storage) {
        Item item = itemStack.getItem();
        if (item instanceof IFunctionCouldEnable) {
            IFunctionCouldEnable function = (IFunctionCouldEnable)item;
            return function.isEnabled(itemStack, storage) ? target : original;
        }
        return target;
    }

    public static void sendToClient(ServerPlayer serverPlayer, Inventory inventory) {
        ArrayList<ItemStack> itemStacks = CuriosUtils.getCurios((LivingEntity)serverPlayer);
        itemStacks.addAll((Collection<ItemStack>)inventory.items);
        byte watch = 0;
        byte weatherRadio = 0;
        byte sextant = 0;
        byte guide = 0;
        byte detector = 0;
        byte analyzer = 0;
        byte radar = 0;
        byte counter = 0;
        byte dpsMeter = 0;
        byte stopwatch = 0;
        byte compass = 0;
        byte depthMeter = 0;
        byte lens = 0;
        for (ItemStack stack : itemStacks) {
            TooltipComponentsValue value;
            AccessoriesComponent component = TCUtils.getAccessoriesComponent(stack);
            if (component == null || (value = component.get(TCItems.INFORMATION)) == null) continue;
            Set<TooltipComponentsValue.Storage> list = value.getSet();
            if (watch < 1 && list.contains(TCItems.HOUR$WATCH)) {
                watch = InfoCurioCheckPacketS2C.checkEnabled(watch, (byte)1, stack, TCItems.HOUR$WATCH);
            } else if (watch < 2 && list.contains(TCItems.HALF$HOUR$WATCH)) {
                watch = InfoCurioCheckPacketS2C.checkEnabled(watch, (byte)2, stack, TCItems.HALF$HOUR$WATCH);
            } else if (watch < 3 && list.contains(TCItems.MINUTE$WATCH)) {
                watch = InfoCurioCheckPacketS2C.checkEnabled(watch, (byte)3, stack, TCItems.MINUTE$WATCH);
            }
            if (weatherRadio == 0 && list.contains(TCItems.WEATHER$RADIO)) {
                weatherRadio = InfoCurioCheckPacketS2C.checkEnabled(weatherRadio, (byte)1, stack, TCItems.WEATHER$RADIO);
            }
            if (sextant == 0 && list.contains(TCItems.$SEXTANT)) {
                sextant = InfoCurioCheckPacketS2C.checkEnabled(sextant, (byte)1, stack, TCItems.$SEXTANT);
            }
            if (guide == 0 && list.contains(TCItems.FISHERMANS$POCKET$GUIDE)) {
                guide = InfoCurioCheckPacketS2C.checkEnabled(guide, (byte)1, stack, TCItems.FISHERMANS$POCKET$GUIDE);
            }
            if (detector == 0 && list.contains(TCItems.METAL$DETECTOR)) {
                detector = InfoCurioCheckPacketS2C.checkEnabled(detector, (byte)1, stack, TCItems.METAL$DETECTOR);
            }
            if (analyzer == 0 && list.contains(TCItems.LIFE$FORM$ANALYZER)) {
                analyzer = InfoCurioCheckPacketS2C.checkEnabled(analyzer, (byte)1, stack, TCItems.LIFE$FORM$ANALYZER);
            }
            if (radar == 0 && list.contains(TCItems.$RADAR)) {
                radar = InfoCurioCheckPacketS2C.checkEnabled(radar, (byte)1, stack, TCItems.$RADAR);
            }
            if (counter == 0 && list.contains(TCItems.TALLY$COUNTER)) {
                counter = InfoCurioCheckPacketS2C.checkEnabled(counter, (byte)1, stack, TCItems.TALLY$COUNTER);
            }
            if (dpsMeter == 0 && list.contains(TCItems.DPS$METER)) {
                dpsMeter = InfoCurioCheckPacketS2C.checkEnabled(dpsMeter, (byte)1, stack, TCItems.DPS$METER);
            }
            if (stopwatch == 0 && list.contains(TCItems.$STOPWATCH)) {
                stopwatch = InfoCurioCheckPacketS2C.checkEnabled(stopwatch, (byte)1, stack, TCItems.$STOPWATCH);
            }
            if (compass == 0 && list.contains(TCItems.$COMPASS)) {
                compass = InfoCurioCheckPacketS2C.checkEnabled(compass, (byte)1, stack, TCItems.$COMPASS);
            }
            if (depthMeter == 0 && list.contains(TCItems.DEPTH$METER)) {
                depthMeter = InfoCurioCheckPacketS2C.checkEnabled(depthMeter, (byte)1, stack, TCItems.DEPTH$METER);
            }
            if (lens != 0 || !list.contains(TCItems.MECHANICAL$LENS)) continue;
            lens = InfoCurioCheckPacketS2C.checkEnabled(lens, (byte)1, stack, TCItems.MECHANICAL$LENS);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new InfoCurioCheckPacketS2C(serverPlayer.getId(), new byte[]{watch, weatherRadio, sextant, guide, detector, analyzer, radar, counter, dpsMeter, stopwatch, compass, depthMeter, lens}), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToOthers(ServerPlayer serverPlayer) {
        boolean equals;
        ArrayList<ItemStack> itemStacks = CuriosUtils.getCurios((LivingEntity)serverPlayer);
        itemStacks.addAll((Collection<ItemStack>)serverPlayer.getInventory().items);
        byte watch = -125;
        byte weatherRadio = -128;
        byte sextant = -128;
        byte guide = -128;
        byte detector = -128;
        byte analyzer = -128;
        byte radar = -128;
        byte counter = -128;
        byte dpsMeter = -128;
        byte stopwatch = -128;
        byte compass = -128;
        byte depthMeter = -128;
        byte lens = -128;
        for (ItemStack stack : itemStacks) {
            TooltipComponentsValue value;
            AccessoriesComponent component = TCUtils.getAccessoriesComponent(stack);
            if (component == null || (value = component.get(TCItems.INFORMATION)) == null) continue;
            Set<TooltipComponentsValue.Storage> list = value.getSet();
            if (watch > -126 && list.contains(TCItems.HOUR$WATCH)) {
                watch = InfoCurioCheckPacketS2C.checkEnabled(watch, (byte)-126, stack, TCItems.HOUR$WATCH);
            } else if (watch > -127 && list.contains(TCItems.HALF$HOUR$WATCH)) {
                watch = InfoCurioCheckPacketS2C.checkEnabled(watch, (byte)-127, stack, TCItems.HALF$HOUR$WATCH);
            } else if (watch > -128 && list.contains(TCItems.MINUTE$WATCH)) {
                watch = InfoCurioCheckPacketS2C.checkEnabled(watch, (byte)-128, stack, TCItems.MINUTE$WATCH);
            }
            if (weatherRadio == -128 && list.contains(TCItems.WEATHER$RADIO)) {
                weatherRadio = InfoCurioCheckPacketS2C.checkEnabled(weatherRadio, (byte)-1, stack, TCItems.WEATHER$RADIO);
            }
            if (sextant == -128 && list.contains(TCItems.$SEXTANT)) {
                sextant = InfoCurioCheckPacketS2C.checkEnabled(sextant, (byte)-1, stack, TCItems.$SEXTANT);
            }
            if (guide == -128 && list.contains(TCItems.FISHERMANS$POCKET$GUIDE)) {
                guide = InfoCurioCheckPacketS2C.checkEnabled(guide, (byte)-1, stack, TCItems.FISHERMANS$POCKET$GUIDE);
            }
            if (detector == -128 && list.contains(TCItems.METAL$DETECTOR)) {
                detector = InfoCurioCheckPacketS2C.checkEnabled(detector, (byte)-1, stack, TCItems.METAL$DETECTOR);
            }
            if (analyzer == -128 && list.contains(TCItems.LIFE$FORM$ANALYZER)) {
                analyzer = InfoCurioCheckPacketS2C.checkEnabled(analyzer, (byte)-1, stack, TCItems.LIFE$FORM$ANALYZER);
            }
            if (radar == -128 && list.contains(TCItems.$RADAR)) {
                radar = InfoCurioCheckPacketS2C.checkEnabled(radar, (byte)-1, stack, TCItems.$RADAR);
            }
            if (counter == -128 && list.contains(TCItems.TALLY$COUNTER)) {
                counter = InfoCurioCheckPacketS2C.checkEnabled(counter, (byte)-1, stack, TCItems.TALLY$COUNTER);
            }
            if (dpsMeter == -128 && list.contains(TCItems.DPS$METER)) {
                dpsMeter = InfoCurioCheckPacketS2C.checkEnabled(dpsMeter, (byte)-1, stack, TCItems.DPS$METER);
            }
            if (stopwatch == -128 && list.contains(TCItems.$STOPWATCH)) {
                stopwatch = InfoCurioCheckPacketS2C.checkEnabled(stopwatch, (byte)-1, stack, TCItems.$STOPWATCH);
            }
            if (compass == -128 && list.contains(TCItems.$COMPASS)) {
                compass = InfoCurioCheckPacketS2C.checkEnabled(compass, (byte)-1, stack, TCItems.$COMPASS);
            }
            if (depthMeter == -128 && list.contains(TCItems.DEPTH$METER)) {
                depthMeter = InfoCurioCheckPacketS2C.checkEnabled(depthMeter, (byte)-1, stack, TCItems.DEPTH$METER);
            }
            if (lens != -128 || !list.contains(TCItems.MECHANICAL$LENS)) continue;
            lens = InfoCurioCheckPacketS2C.checkEnabled(lens, (byte)-1, stack, TCItems.MECHANICAL$LENS);
        }
        boolean bl = equals = watch == -125 && weatherRadio == -128 && sextant == -128 && guide == -128 && detector == -128 && analyzer == -128 && radar == -128 && counter == -128 && dpsMeter == -128 && stopwatch == -128 && compass == -128 && depthMeter == -128 && lens == -128;
        if (equals) {
            return;
        }
        InfoCurioCheckPacketS2C packet = new InfoCurioCheckPacketS2C(serverPlayer.getId(), new byte[]{watch, weatherRadio, sextant, guide, detector, analyzer, radar, counter, dpsMeter, stopwatch, compass, depthMeter, lens});
        PlayerTeam team = serverPlayer.getTeam();
        serverPlayer.serverLevel().players().forEach(arg_0 -> InfoCurioCheckPacketS2C.lambda$sendToOthers$2(serverPlayer, (Team)team, packet, arg_0));
    }

    private static /* synthetic */ void lambda$sendToOthers$2(ServerPlayer serverPlayer, Team team, InfoCurioCheckPacketS2C packet, ServerPlayer player) {
        if (player != serverPlayer && player.getTeam() == team && player.distanceToSqr((Entity)serverPlayer) < 1024.0) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

