/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.PlayerClimbHandler;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.util.TCUtils;

public record PlayerClimbPacketS2C(byte climberAmount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerClimbPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("player_climb"));
    public static final StreamCodec<ByteBuf, PlayerClimbPacketS2C> STREAM_CODEC = ByteBufCodecs.BYTE.map(PlayerClimbPacketS2C::new, PlayerClimbPacketS2C::climberAmount);

    public CustomPacketPayload.Type<PlayerClimbPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                PlayerClimbHandler.handlePacket(this);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerClimbPacketS2C(TCUtils.getAccessoriesValue((LivingEntity)serverPlayer, TCItems.WALL$CLIMB)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

