/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.common.attachment.AccessoriesAttachment;
import org.confluence.terra_curio.common.init.TCAttachments;
import org.confluence.terra_curio.common.init.TCItems;

public record PlayerJumpPacketS2C(float fartSpeed, float sandstormSpeed, int sandstormTicks, float blizzardSpeed, int blizzardTicks, float tsunamiSpeed, float cloudSpeed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerJumpPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("player_jump_s2c"));
    public static final StreamCodec<ByteBuf, PlayerJumpPacketS2C> STREAM_CODEC = new StreamCodec<ByteBuf, PlayerJumpPacketS2C>(){

        public void encode(ByteBuf buffer, PlayerJumpPacketS2C value) {
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)Float.valueOf(value.fartSpeed));
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)Float.valueOf(value.sandstormSpeed));
            ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)value.sandstormTicks);
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)Float.valueOf(value.blizzardSpeed));
            ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)value.blizzardTicks);
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)Float.valueOf(value.tsunamiSpeed));
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)Float.valueOf(value.cloudSpeed));
        }

        public PlayerJumpPacketS2C decode(ByteBuf buffer) {
            float t1 = ((Float)ByteBufCodecs.FLOAT.decode((Object)buffer)).floatValue();
            float t2 = ((Float)ByteBufCodecs.FLOAT.decode((Object)buffer)).floatValue();
            int t3 = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
            float t4 = ((Float)ByteBufCodecs.FLOAT.decode((Object)buffer)).floatValue();
            int t5 = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
            float t6 = ((Float)ByteBufCodecs.FLOAT.decode((Object)buffer)).floatValue();
            float t7 = ((Float)ByteBufCodecs.FLOAT.decode((Object)buffer)).floatValue();
            return new PlayerJumpPacketS2C(t1, t2, t3, t4, t5, t6, t7);
        }
    };

    public CustomPacketPayload.Type<PlayerJumpPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                PlayerJumpHandler.handleJumpPacket(this);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(ServerPlayer serverPlayer) {
        AccessoriesAttachment attachment = (AccessoriesAttachment)serverPlayer.getData(TCAttachments.ACCESSORIES);
        Tuple<Float, Integer> sandStorm = attachment.getValue(TCItems.SAND$STORM);
        Tuple<Float, Integer> blizzard = attachment.getValue(TCItems.BLIZZARD);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerJumpPacketS2C(attachment.getValue(TCItems.FART).floatValue(), ((Float)sandStorm.getA()).floatValue(), (Integer)sandStorm.getB(), ((Float)blizzard.getA()).floatValue(), (Integer)blizzard.getB(), attachment.getValue(TCItems.TSUNAMI).floatValue(), attachment.getValue(TCItems.CLOUD).floatValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

