/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;

public record SetItemEntityPickupDelayPacketS2C(int id, int delay) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetItemEntityPickupDelayPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("set_item_entity_pickup_delay"));
    public static final StreamCodec<ByteBuf, SetItemEntityPickupDelayPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetItemEntityPickupDelayPacketS2C::id, (StreamCodec)ByteBufCodecs.VAR_INT, SetItemEntityPickupDelayPacketS2C::delay, SetItemEntityPickupDelayPacketS2C::new);

    public CustomPacketPayload.Type<SetItemEntityPickupDelayPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                TCClientPacketHandler.handleItemPickupDelay(this);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToAll(int id, int delay) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SetItemEntityPickupDelayPacketS2C(id, delay), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            TerraCurio.LOGGER.warn("Trying send a packet with no server!");
        }
    }
}

