/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.handler.StepStoolHandler;
import top.theillusivec4.curios.api.SlotContext;

public record StepStoolSteppingPacketS2C(int slot, int maxStep) implements CustomPacketPayload
{
    public static final int NO_CURIO = -1;
    public static final int RESET_STEP = -2;
    public static final CustomPacketPayload.Type<StepStoolSteppingPacketS2C> TYPE = new CustomPacketPayload.Type(TerraCurio.asResource("step_stool_stepping_s2c"));
    public static final StreamCodec<ByteBuf, StepStoolSteppingPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StepStoolSteppingPacketS2C::slot, (StreamCodec)ByteBufCodecs.VAR_INT, StepStoolSteppingPacketS2C::maxStep, StepStoolSteppingPacketS2C::new);

    public CustomPacketPayload.Type<StepStoolSteppingPacketS2C> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player().isLocalPlayer()) {
                StepStoolHandler.handlePacket(this);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void sendToClient(SlotContext slotContext, int maxStep) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new StepStoolSteppingPacketS2C(slotContext.index(), maxStep), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void resetStep(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new StepStoolSteppingPacketS2C(-2, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

