/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.init.TCDataComponentTypes;
import org.confluence.terra_curio.util.TCUtils;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtils {
    public static boolean noSameCurio(LivingEntity living, Class<?> clazz) {
        return CuriosUtils.noSameCurio(living, itemStack -> clazz.isInstance(itemStack.getItem()));
    }

    public static boolean noSameCurio(LivingEntity living, ValueType<?, ? extends PrimitiveValue<?>> type) {
        return CuriosUtils.noSameCurio(living, itemStack -> {
            AccessoriesComponent component = (AccessoriesComponent)itemStack.get(TCDataComponentTypes.ACCESSORIES);
            return component == null || !component.types().containsKey(type);
        });
    }

    public static boolean noSameCurio(LivingEntity living, Predicate<ItemStack> predicate) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return true;
        }
        for (ICurioStacksHandler curioStacksHandler : ((ICuriosItemHandler)curiosInventory.get()).getCurios().values()) {
            IDynamicStackHandler stackHandler = curioStacksHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (stack.isEmpty() || !predicate.test(stack)) continue;
                return false;
            }
        }
        return true;
    }

    public static <C extends Item> boolean noSameCurio(LivingEntity living, C curio) {
        return CuriosUtils.noSameCurio(living, itemStack -> itemStack.getItem() == curio);
    }

    public static boolean hasCurio(LivingEntity living, Class<?> clazz) {
        return !CuriosUtils.noSameCurio(living, clazz);
    }

    public static boolean hasCurio(LivingEntity living, ValueType<?, ? extends PrimitiveValue<?>> type) {
        return !CuriosUtils.noSameCurio(living, type);
    }

    public static boolean hasCurio(LivingEntity living, Predicate<ItemStack> predicate) {
        return !CuriosUtils.noSameCurio(living, predicate);
    }

    public static <C extends Item> boolean hasCurio(LivingEntity living, C curio) {
        return !CuriosUtils.noSameCurio(living, curio);
    }

    public static <T, V extends PrimitiveValue<T>> T calculateValue(LivingEntity living, ValueType<T, V> type) {
        V value = type.newInstance(type.defaultValue());
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return value.get();
        }
        for (ICurioStacksHandler curioStacksHandler : ((ICuriosItemHandler)curiosInventory.get()).getCurios().values()) {
            IDynamicStackHandler stackHandler = curioStacksHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                V other;
                AccessoriesComponent component;
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (stack.isEmpty() || (component = TCUtils.getAccessoriesComponent(stack)) == null || (other = component.get(type)) == null) continue;
                T t = value.combine(other, type.combineRule());
                value = type.newInstance(t);
            }
        }
        return value.get();
    }

    @Nullable
    public static <C> C findCurio(LivingEntity living, Class<C> clazz) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return null;
        }
        Optional results = ((ICuriosItemHandler)curiosInventory.get()).findFirstCurio(itemStack -> clazz.isInstance(itemStack.getItem()));
        return results.map(result -> clazz.cast(result.stack().getItem())).orElse(null);
    }

    @Nullable
    public static <C extends Item> ItemStack findCurio(LivingEntity living, C curio) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return null;
        }
        Optional results = ((ICuriosItemHandler)curiosInventory.get()).findFirstCurio(itemStack -> itemStack.getItem() == curio);
        return results.map(SlotResult::stack).orElse(null);
    }

    @Nullable
    public static ItemStack findCurio(LivingEntity living, Predicate<ItemStack> predicate) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return null;
        }
        Optional results = ((ICuriosItemHandler)curiosInventory.get()).findFirstCurio(predicate);
        return results.map(SlotResult::stack).orElse(null);
    }

    @Nullable
    public static <C extends Item> ItemStack findCurioAt(LivingEntity living, C curio, String id) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return null;
        }
        Map curios = ((ICuriosItemHandler)curiosInventory.get()).getCurios();
        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
        if (stacksHandler != null) {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (stack.isEmpty() || stack.getItem() != curio) continue;
                return stack;
            }
        }
        return null;
    }

    public static ArrayList<ItemStack> getCurios(LivingEntity living) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return items;
        }
        IItemHandlerModifiable itemHandlerModifiable = ((ICuriosItemHandler)curiosInventory.get()).getEquippedCurios();
        for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
            ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            items.add(itemStack);
        }
        return items;
    }

    public static <C> ArrayList<C> getCurios(LivingEntity living, Class<C> clazz) {
        ArrayList<C> items = new ArrayList<C>();
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return items;
        }
        IItemHandlerModifiable itemHandlerModifiable = ((ICuriosItemHandler)curiosInventory.get()).getEquippedCurios();
        for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
            ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
            Item item = itemStack.getItem();
            if (!clazz.isInstance(item)) continue;
            items.add(clazz.cast(item));
        }
        return items;
    }

    @Nullable
    public static ItemStack getSlot(LivingEntity living, String id, int index) {
        ItemStack stack;
        IDynamicStackHandler stackHandler;
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return null;
        }
        Map curios = ((ICuriosItemHandler)curiosInventory.get()).getCurios();
        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
        if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots() && !(stack = stackHandler.getStackInSlot(index)).isEmpty()) {
            return stack;
        }
        return null;
    }

    @Nullable
    public static ItemStack getSlot(LivingEntity living, Predicate<ItemStack> predicate, int index) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)living);
        if (curiosInventory.isEmpty()) {
            return null;
        }
        for (ICurioStacksHandler curioStacksHandler : ((ICuriosItemHandler)curiosInventory.get()).getCurios().values()) {
            ItemStack stack;
            IDynamicStackHandler stackHandler = curioStacksHandler.getStacks();
            if (stackHandler.getSlots() <= index || (stack = stackHandler.getStackInSlot(index)).isEmpty() || !predicate.test(stack)) continue;
            return stack;
        }
        return null;
    }
}

