/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.UnitValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;
import org.confluence.terra_curio.common.attachment.AccessoriesAttachment;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.entity.BeeProjectile;
import org.confluence.terra_curio.common.entity.StarCloakEntity;
import org.confluence.terra_curio.common.init.TCAttachments;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_curio.common.init.TCDataComponentTypes;
import org.confluence.terra_curio.common.init.TCDataMaps;
import org.confluence.terra_curio.common.init.TCEffects;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCTags;
import org.confluence.terra_curio.mixed.IEntity;
import org.confluence.terra_curio.mixed.ILivingEntity;
import org.confluence.terra_curio.network.InfoDisablePacket;
import org.confluence.terra_curio.network.c2s.PlayerSprintPacketC2S;
import org.confluence.terra_curio.network.s2c.BroadcastRenderPacketS2C;
import org.confluence.terra_curio.network.s2c.CurioExistsPacketS2C;
import org.confluence.terra_curio.network.s2c.FluidWalkUpdatePacketS2C;
import org.confluence.terra_curio.network.s2c.InfiniteFlightPacketS2C;
import org.confluence.terra_curio.network.s2c.InfoCurioCheckPacketS2C;
import org.confluence.terra_curio.network.s2c.PlayerClimbPacketS2C;
import org.confluence.terra_curio.network.s2c.PlayerFlyPacketS2C;
import org.confluence.terra_curio.network.s2c.PlayerJumpPacketS2C;
import org.confluence.terra_curio.network.s2c.RightClickSubtractorPacketS2C;
import org.confluence.terra_curio.util.CuriosUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class TCUtils {
    public static final AttributeModifier ICE_SPEED_MODIFIER = new AttributeModifier(TerraCurio.asResource("ice_speed"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static boolean sprintKeyDown = false;

    @ApiStatus.Internal
    public static <T, V extends PrimitiveValue<T>> V tryCast(PrimitiveValue<?> primitiveValue) {
        return (V)primitiveValue;
    }

    public static void applyFireAttack(Player player, Entity entity) {
        if (TCUtils.hasAccessoriesType((LivingEntity)player, TCItems.FIRE$ATTACK)) {
            float f = player.getRandom().nextFloat();
            int time = f < 0.25f ? 120 : (f < 0.375f ? 80 : 40);
            entity.igniteForTicks(time);
        }
    }

    public static boolean isInvulnerableTo(Entity self, DamageSource damageSource) {
        if (!(self instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)self;
        AccessoriesAttachment attachment = (AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES);
        Entity attacker = damageSource.getEntity();
        if (attacker != null && attacker.getType().is(attachment.getValue(TCItems.MOB$IGNORE))) {
            return true;
        }
        if (((IEntity)living).terra_curio$getCthulhuSprintingTime() > 10 && attachment.contains(TCItems.SHIELD$OF$CTHULHU)) {
            return true;
        }
        if (attachment.contains(TCItems.FIRE$IMMUNE) && TCUtils.isFire(damageSource)) {
            return true;
        }
        return TCAttributes.applyDodge(living, living.getRandom());
    }

    public static boolean isFire(DamageSource damageSource) {
        return damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.ON_FIRE) || damageSource.is(DamageTypes.HOT_FLOOR) || damageSource.is(DamageTypes.UNATTRIBUTED_FIREBALL) || damageSource.is(DamageTypes.FIREBALL);
    }

    public static float applyInjuryFree(LivingEntity living, float amount) {
        float injuryFree = TCUtils.getAccessoriesValue(living, TCItems.INJURY$FREE).floatValue();
        return amount * (1.0f - injuryFree);
    }

    public static void applyStarClock(LivingEntity living, RandomSource random) {
        AccessoriesAttachment attachment = (AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES);
        boolean starClock = attachment.contains(TCItems.STAR$CLOCK);
        if (starClock) {
            Level level = living.level();
            List list = level.getEntities((Entity)living, new AABB(living.getOnPos()).inflate(4.0, 3.0, 4.0), entity -> entity instanceof Enemy);
            for (int i = 0; i < 3; ++i) {
                Object target = list.isEmpty() ? living : (Entity)list.get(random.nextInt(list.size()));
                StarCloakEntity entity2 = new StarCloakEntity(level, living, (Entity)target, attachment.getValue(TCItems.STAR$CLOCK));
                level.addFreshEntity((Entity)entity2);
            }
        }
    }

    public static void applyHoneyComb(LivingEntity living, RandomSource random) {
        AccessoriesAttachment attachment = (AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES);
        if (attachment.contains(TCItems.HONEY$COMB)) {
            boolean hasHivePack = attachment.contains(TCItems.HIVE$PACK);
            int summon = random.nextInt(1, hasHivePack ? 5 : 4);
            for (int i = 0; i < summon; ++i) {
                BeeProjectile projectile = new BeeProjectile(living.level(), living, hasHivePack && random.nextBoolean());
                projectile.setPos(living.position().add((double)random.nextInt(3) - 1.0, 2.0, (double)random.nextInt(3) - 1.0));
                living.level().addFreshEntity((Entity)projectile);
            }
            living.addEffect(new MobEffectInstance(TCEffects.HONEY, 100));
        }
    }

    public static void applyIgniteArrow(LivingEntity living, AbstractArrow arrow) {
        if (TCUtils.hasAccessoriesType(living, TCItems.IGNITE$ARROW)) {
            arrow.igniteForTicks(2000);
        }
    }

    public static float applyFrozenTurtleShell(LivingEntity living, float amount) {
        if (living.getHealth() / living.getMaxHealth() < 0.5f && TCUtils.hasAccessoriesType(living, TCItems.FROZEN$TURTLE$SHELL)) {
            return amount * 0.75f;
        }
        return amount;
    }

    public static float applyBrainOfConfusion(LivingEntity living, RandomSource randomSource, DamageSource damageSource, float amount) {
        if (damageSource.is(TCTags.HARMFUL_EFFECT)) {
            return amount;
        }
        if (!((AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES)).contains(TCItems.BRAIN$OF$CONFUSION)) {
            return amount;
        }
        if (randomSource.nextFloat() < 0.6f + amount * 0.02f) {
            float rangeMin = amount <= 120.0f ? amount * 0.5f + 200.0f : (amount <= 266.6f ? amount * 0.375f + 275.0f : (amount <= 440.0f ? amount * 0.1875f + 487.5f : amount * 0.046875f + 796.875f));
            float rangeMax = amount <= 20.0f ? amount * 2.0f + 300.0f : (amount <= 46.6f ? amount * 1.5f + 350.0f : (amount <= 100.0f ? amount * 0.75f + 525.0f : amount * 0.1875f + 806.25f));
            float range = Mth.nextFloat((RandomSource)randomSource, (float)rangeMin, (float)rangeMax) / 24.0f;
            int duration = randomSource.nextInt((int)(90.0f + amount / 3.0f), (int)(300.0f + amount / 2.0f));
            living.level().getEntities((Entity)living, new AABB(living.getOnPos()).inflate((double)range), entity -> entity instanceof Enemy).forEach(enemy -> {
                if (enemy instanceof LivingEntity) {
                    LivingEntity living1 = (LivingEntity)enemy;
                    living1.addEffect(new MobEffectInstance(TCEffects.CONFUSED, duration));
                }
            });
        }
        if (randomSource.nextFloat() < 0.1667f && !living.hasEffect(TCEffects.CEREBRAL_MINDTRICK)) {
            living.addEffect(new MobEffectInstance(TCEffects.CEREBRAL_MINDTRICK, 80));
            return 0.0f;
        }
        return amount;
    }

    public static boolean magicQuiver$shouldConsume(LivingEntity living) {
        return !((AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES)).contains(TCItems.MAGIC$QUIVER) || living.getRandom().nextFloat() >= 0.2f;
    }

    public static void resetClientPacket(ServerPlayer serverPlayer) {
        InfoCurioCheckPacketS2C.sendToClient(serverPlayer, serverPlayer.getInventory());
        InfoDisablePacket.sendToClient(serverPlayer);
        CurioExistsPacketS2C.sendToClient(serverPlayer);
        PlayerClimbPacketS2C.sendToClient(serverPlayer);
        PlayerJumpPacketS2C.sendToClient(serverPlayer);
        PlayerFlyPacketS2C.sendToClient(serverPlayer);
        RightClickSubtractorPacketS2C.sendToClient(serverPlayer);
        InfiniteFlightPacketS2C.sendToClient(serverPlayer);
        BroadcastRenderPacketS2C.sendToAll(serverPlayer);
        FluidWalkUpdatePacketS2C.sendToClient(serverPlayer);
    }

    public static float applyLavaHurtReduce(LivingEntity living, DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypes.LAVA)) {
            float value = TCUtils.getAccessoriesValue(living, TCItems.LAVA$HURT$REDUCE).floatValue();
            living.igniteForTicks(140);
            return amount * (1.0f - value);
        }
        return amount;
    }

    public static void onChangedBlock(LivingEntity living, ServerLevel level) {
        if (living.onGround()) {
            AccessoriesAttachment attachment = (AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES);
            BlockPos onPos = living.getOnPos();
            if (attachment.contains(TCItems.FLOWER$BOOTS) && level.getBlockState(onPos).is(TCTags.FLOWER_BOOTS_AVAILABLE)) {
                BlockPos abovePos = onPos.above();
                RandomSource random = level.random;
                for (BlockPos aroundPos : BlockPos.betweenClosed((BlockPos)abovePos.offset(-1, 0, -1), (BlockPos)abovePos.offset(1, 0, 1))) {
                    List list;
                    if (!level.getBlockState(aroundPos.below()).is(TCTags.FLOWER_BOOTS_AVAILABLE) || level.getBlockState(aroundPos).isCollisionShapeFullBlock((BlockGetter)level, aroundPos) || !(random.nextFloat() < 0.3f) || !level.getBlockState(aroundPos).isAir() || (list = ((Biome)level.getBiome(aroundPos).value()).getGenerationSettings().getFlowerFeatures()).isEmpty()) continue;
                    ((PlacedFeature)((RandomPatchConfiguration)((ConfiguredFeature)list.getFirst()).config()).feature().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, aroundPos);
                }
            }
            if (attachment.contains(TCItems.ICE$SPEED)) {
                AttributeInstance instance = living.getAttribute(Attributes.MOVEMENT_SPEED);
                assert (instance != null);
                if (level.getBlockState(onPos).is(BlockTags.ICE)) {
                    if (!instance.hasModifier(ICE_SPEED_MODIFIER.id())) {
                        instance.addTransientModifier(ICE_SPEED_MODIFIER);
                    }
                } else {
                    instance.removeModifier(ICE_SPEED_MODIFIER);
                }
            }
        }
    }

    public static void updateWalkableFluidStates(Player player) {
        HashSet<FluidState> walkableFluidStates = new HashSet<FluidState>();
        Set<TagKey<Fluid>> tagKeys = CuriosUtils.calculateValue((LivingEntity)player, TCItems.FLUID$WALK);
        BuiltInRegistries.FLUID.stream().flatMap(fluid -> fluid.getStateDefinition().getPossibleStates().stream()).forEach(state -> {
            if (tagKeys.stream().anyMatch(arg_0 -> ((FluidState)state).is(arg_0))) {
                walkableFluidStates.add((FluidState)state);
            }
        });
        ((ILivingEntity)player).terra_curio$resetLastWalkedFluidState(walkableFluidStates);
    }

    public static void applyFluidWalk(Player player) {
        if (player.getEyeInFluidType() == NeoForgeMod.EMPTY_TYPE.value()) {
            BlockPos pos = player.blockPosition();
            Level level = player.level();
            if (level.getFluidState(pos.above()).isEmpty() && player.canStandOnFluid(level.getFluidState(pos))) {
                Vec3 motion = player.getDeltaMovement();
                player.setDeltaMovement(motion.x, Math.max(0.0, motion.y), motion.z);
                player.setOnGround(true);
                float f = Math.min(0.1f, (float)motion.horizontalDistance());
                player.bob += (f - player.bob) * 0.8f;
            }
        }
    }

    public static boolean isFluidWalkable(LivingEntity living, FluidState fluidState) {
        if (fluidState.isEmpty() || living.isCrouching() || !(living instanceof Player)) {
            return false;
        }
        ILivingEntity iLiving = (ILivingEntity)living;
        if (iLiving.terra_curio$getLastWalkedFluidState() == fluidState) {
            return true;
        }
        if (iLiving.terra_curio$isFluidWalkable(fluidState)) {
            iLiving.terra_curio$setLastWalkedFluidState(fluidState);
            return true;
        }
        return false;
    }

    public static boolean applyTotemAbility(LivingEntity living) {
        ILivingEntity iLiving = (ILivingEntity)living;
        if (iLiving.terra_curio$getTotemCooldown() == 0) {
            int cooldown = TCUtils.getAccessoriesValue(living, TCItems.TOTEM$WITH$COOLDOWN);
            if (cooldown > 0) {
                living.setHealth(1.0f);
                living.removeEffectsCuredBy(EffectCures.PROTECTED_BY_TOTEM);
                living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
                living.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                living.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
                living.level().broadcastEntityEvent((Entity)living, (byte)35);
                iLiving.terra_curio$setTotemCooldown(cooldown);
                return true;
            }
            iLiving.terra_curio$setTotemCooldown(-1);
        }
        return false;
    }

    public static void applyCthulhuTouch(Player player, Entity touched) {
        if (player != touched && ((IEntity)player).terra_curio$getCthulhuSprintingTime() > 20 && touched instanceof LivingEntity) {
            Vec3 vector = player.getDeltaMovement();
            touched.addDeltaMovement(new Vec3(vector.x * 1.2, 0.2, vector.z * 1.2));
            touched.hurt(player.damageSources().playerAttack(player), 7.8f);
            player.setDeltaMovement(vector.scale(-0.9));
            ((IEntity)player).terra_curio$setCthulhuSprintingTime(20);
        }
    }

    public static void applyCthulhuSprinting(boolean down, Player player) {
        if (((IEntity)player).terra_curio$getCthulhuSprintingTime() > 0 || player.isFallFlying()) {
            return;
        }
        boolean sprint = false;
        if (player.isLocalPlayer()) {
            if (down) {
                if (!sprintKeyDown && TCClientPacketHandler.isHasCthulhu()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)PlayerSprintPacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    sprintKeyDown = true;
                    sprint = true;
                }
            } else {
                sprintKeyDown = false;
            }
        } else if (TCUtils.hasAccessoriesType((LivingEntity)player, TCItems.SHIELD$OF$CTHULHU)) {
            sprint = true;
        }
        if (sprint) {
            float f = player.getYRot() * ((float)Math.PI / 180);
            double factor = player.onGround() ? 1.6 : 1.2;
            player.setDeltaMovement(player.getDeltaMovement().add((double)(-Mth.sin((float)f)) * factor, 0.0, (double)Mth.cos((float)f) * factor));
            ((IEntity)player).terra_curio$setCthulhuSprintingTime(32);
        }
    }

    public static boolean applyLavaImmune(boolean original, Entity self) {
        if (!self.level().isClientSide) {
            if (original) {
                if (((AccessoriesAttachment)self.getData(TCAttachments.ACCESSORIES)).decreaseLavaImmuneTicks()) {
                    return false;
                }
            } else {
                ((AccessoriesAttachment)self.getData(TCAttachments.ACCESSORIES)).increaseLavaImmuneTicks();
            }
        }
        return original;
    }

    public static boolean hasAccessoriesType(LivingEntity living, ValueType<Unit, UnitValue> type) {
        return ((AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES)).contains(type);
    }

    public static <T, V extends PrimitiveValue<T>> T getAccessoriesValue(LivingEntity living, ValueType<T, V> type) {
        return ((AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES)).getValue(type);
    }

    @Nullable
    public static AccessoriesComponent getAccessoriesComponent(ItemStack itemStack) {
        AccessoriesComponent component = (AccessoriesComponent)itemStack.getItemHolder().getData(TCDataMaps.ACCESSORIES);
        if (component != null || (component = (AccessoriesComponent)itemStack.get(TCDataComponentTypes.ACCESSORIES)) != null) {
            return component;
        }
        return null;
    }

    public static boolean isIceSafe(LivingEntity self) {
        Player player;
        if (self instanceof Player && (player = (Player)self).isLocalPlayer()) {
            return TCClientPacketHandler.isIceSafe();
        }
        return TCUtils.hasAccessoriesType(self, TCItems.ICE$SAFE);
    }
}

