/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.capability.ability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.confluence.terra_curio.capability.ability.PlayerAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AbilityProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<PlayerAbility> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerAbility>(){});
    private PlayerAbility playerAbility;
    private final LazyOptional<PlayerAbility> abilityLazyOptional = LazyOptional.of(this::getOrCreateStorage);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, this.abilityLazyOptional);
    }

    public CompoundTag serializeNBT() {
        return this.getOrCreateStorage().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getOrCreateStorage().deserializeNBT(nbt);
    }

    private PlayerAbility getOrCreateStorage() {
        if (this.playerAbility == null) {
            this.playerAbility = new PlayerAbility();
        }
        return this.playerAbility;
    }
}

