/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.capability.ability;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.confluence.terra_curio.capability.ability.AbilityProvider;
import org.confluence.terra_curio.item.curio.ILavaImmune;
import org.confluence.terra_curio.item.curio.combat.IFireImmune;
import org.confluence.terra_curio.item.curio.combat.IInvulnerableTime;
import org.confluence.terra_curio.item.curio.movement.IFallResistance;
import org.confluence.terra_curio.item.curio.movement.IFluidWalk;
import org.confluence.terra_curio.item.curio.movement.IJumpBoost;
import top.theillusivec4.curios.api.CuriosApi;

public final class PlayerAbility
implements INBTSerializable<CompoundTag> {
    private double jumpBoost = 1.0;
    private int fallResistance = 0;
    private int invulnerableTime = 20;
    private boolean fireImmune = false;
    private int maxLavaImmuneTicks = 0;
    private transient int remainLavaImmuneTicks = 0;
    private final List<TagKey<Fluid>> fluidWalk = new ArrayList<TagKey<Fluid>>();

    public void flushAbility(LivingEntity living) {
        AtomicDouble jump = new AtomicDouble(1.0);
        AtomicInteger fall = new AtomicInteger();
        AtomicInteger invul = new AtomicInteger(20);
        AtomicBoolean fire = new AtomicBoolean();
        AtomicInteger lava = new AtomicInteger();
        HashSet fluids = new HashSet();
        HashSet interfaces = new HashSet();
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            IItemHandlerModifiable itemHandlerModifiable = handler.getEquippedCurios();
            for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
                ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
                Item item = itemStack.m_41720_();
                if (item instanceof IJumpBoost) {
                    IJumpBoost iJumpBoost = (IJumpBoost)item;
                    jump.set(Math.max(iJumpBoost.getBoost(), jump.get()));
                }
                if (item instanceof IFallResistance) {
                    IFallResistance iFallResistance = (IFallResistance)item;
                    if (fall.get() != -1) {
                        int distance = iFallResistance.getFallResistance();
                        fall.set(distance < 0 ? -1 : Math.max(distance, fall.get()));
                    }
                }
                if (item instanceof IInvulnerableTime) {
                    IInvulnerableTime iInvulnerableTime = (IInvulnerableTime)item;
                    invul.set(Math.max(iInvulnerableTime.getTime(), this.invulnerableTime));
                }
                if (item instanceof IFireImmune) {
                    fire.set(true);
                }
                if (item instanceof ILavaImmune) {
                    ILavaImmune iLavaImmune = (ILavaImmune)item;
                    lava.set(Math.max(iLavaImmune.getLavaImmuneTicks(), lava.get()));
                }
                if (!(item instanceof IFluidWalk)) continue;
                IFluidWalk iFluidWalk = (IFluidWalk)item;
                fluids.addAll(iFluidWalk.canStandOn());
            }
        });
        this.jumpBoost = jump.get();
        this.fallResistance = fall.get();
        this.invulnerableTime = invul.get();
        this.fireImmune = fire.get();
        this.maxLavaImmuneTicks = lava.get();
        this.fluidWalk.clear();
        this.fluidWalk.addAll(fluids);
    }

    public double getJumpBoost() {
        return this.jumpBoost;
    }

    public int getFallResistance() {
        return this.fallResistance;
    }

    public int getInvulnerableTime() {
        return this.invulnerableTime;
    }

    public boolean isFireImmune() {
        return this.fireImmune;
    }

    public void increaseLavaImmuneTicks() {
        if (this.remainLavaImmuneTicks < this.maxLavaImmuneTicks) {
            ++this.remainLavaImmuneTicks;
        }
    }

    public boolean decreaseLavaImmuneTicks() {
        if (this.remainLavaImmuneTicks > 0) {
            --this.remainLavaImmuneTicks;
            return true;
        }
        return false;
    }

    public boolean canWalkOnFluid(FluidState state) {
        return this.fluidWalk.stream().anyMatch(arg_0 -> ((FluidState)state).m_205070_(arg_0));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("jumpBoost", this.jumpBoost);
        nbt.m_128405_("fallResistance", this.fallResistance);
        nbt.m_128405_("invulnerableTime", this.invulnerableTime);
        nbt.m_128379_("fireImmune", this.fireImmune);
        nbt.m_128405_("maxLavaImmuneTicks", this.maxLavaImmuneTicks);
        ListTag listTag = new ListTag();
        Codec codec = TagKey.m_203877_((ResourceKey)Registries.f_256808_);
        for (TagKey<Fluid> tag : this.fluidWalk) {
            codec.encodeStart((DynamicOps)NbtOps.f_128958_, tag).result().ifPresent(arg_0 -> listTag.add(arg_0));
        }
        nbt.m_128365_("fluidWalk", (Tag)listTag);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.jumpBoost = nbt.m_128459_("jumpBoost");
        this.fallResistance = nbt.m_128451_("fallResistance");
        this.invulnerableTime = nbt.m_128451_("invulnerableTime");
        this.fireImmune = nbt.m_128471_("fireImmune");
        this.maxLavaImmuneTicks = nbt.m_128451_("maxLavaImmuneTicks");
        this.fluidWalk.clear();
        ListTag listTag = nbt.m_128437_("fluidWalk", 10);
        Codec codec = TagKey.m_203877_((ResourceKey)Registries.f_256808_);
        for (Tag tag : listTag) {
            codec.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().ifPresent(pair -> this.fluidWalk.add((TagKey<Fluid>)((TagKey)pair.getFirst())));
        }
    }

    public void copyFrom(PlayerAbility playerAbility) {
        this.jumpBoost = playerAbility.jumpBoost;
        this.fallResistance = playerAbility.fallResistance;
        this.invulnerableTime = playerAbility.invulnerableTime;
        this.fireImmune = playerAbility.fireImmune;
        this.maxLavaImmuneTicks = playerAbility.maxLavaImmuneTicks;
        this.fluidWalk.clear();
        this.fluidWalk.addAll(playerAbility.fluidWalk);
    }

    public static LazyOptional<PlayerAbility> of(LivingEntity living) {
        return living.getCapability(AbilityProvider.CAPABILITY);
    }
}

