/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.color;

import net.minecraft.util.Mth;
import org.joml.Vector3f;

public record FloatRGB(float red, float green, float blue) {
    public static FloatRGB fromVector(Vector3f vector3f) {
        return new FloatRGB(vector3f.x, vector3f.y, vector3f.z);
    }

    public static FloatRGB fromInteger(int color) {
        return new FloatRGB((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public FloatRGB mixture(FloatRGB another, float anotherRatio) {
        float r = Mth.m_14036_((float)(this.red - (this.red - another.red) * anotherRatio), (float)0.0f, (float)1.0f);
        float g = Mth.m_14036_((float)(this.green - (this.green - another.green) * anotherRatio), (float)0.0f, (float)1.0f);
        float b = Mth.m_14036_((float)(this.blue - (this.blue - another.blue) * anotherRatio), (float)0.0f, (float)1.0f);
        return new FloatRGB(r, g, b);
    }

    public int get() {
        return ((int)(this.red * 255.0f) << 16) + ((int)(this.green * 255.0f) << 8) + (int)(this.blue * 255.0f);
    }

    public Vector3f toVector() {
        return new Vector3f(this.red, this.green, this.blue);
    }

    public float[] toArray() {
        return new float[]{this.red, this.green, this.blue};
    }
}

