/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.mixin.LivingEntityAccessor;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.c2s.PlayerJumpPacketC2S;
import org.confluence.terra_curio.network.s2c.PlayerClimbPacketS2C;

@OnlyIn(value=Dist.CLIENT)
public final class PlayerClimbHandler {
    private static boolean wallJumped = false;
    private static int climberAmount = 0;

    public static void handle(LocalPlayer localPlayer, Vec2 vector, boolean jumping) {
        double z;
        float sin;
        if (climberAmount <= 0 || localPlayer.m_20096_() || (double)vector.f_82470_ == 0.0 && (double)vector.f_82471_ == 0.0) {
            wallJumped = true;
            return;
        }
        Vec3 motion = localPlayer.m_20184_();
        double motionY = motion.f_82480_;
        if (motionY > 0.0) {
            return;
        }
        float rad = localPlayer.m_146908_() * ((float)Math.PI / 180);
        float cos = Mth.m_14089_((float)rad);
        double x = vector.f_82470_ * cos + vector.f_82471_ * -(sin = Mth.m_14031_((float)rad));
        if (PlayerClimbHandler.hasMotionToWall(localPlayer, x, z = (double)(vector.f_82470_ * sin + vector.f_82471_ * cos))) {
            if (jumping) {
                if (!wallJumped) {
                    PlayerClimbHandler.wallJump(localPlayer, x, z);
                    wallJumped = true;
                    return;
                }
            } else {
                wallJumped = false;
            }
            if (localPlayer.m_6144_()) {
                motionY = -0.1;
            } else if (climberAmount == 1) {
                motionY = -0.05;
            } else if (climberAmount >= 2) {
                motionY = 0.0;
            }
            localPlayer.f_19812_ = true;
            localPlayer.f_19789_ = 0.0f;
            localPlayer.m_20334_(motion.f_82479_ * 0.93, motionY, motion.f_82481_ * 0.93);
            PlayerJumpHandler.flushState(true);
            NetworkHandler.CHANNEL.sendToServer((Object)new PlayerJumpPacketC2S(false, true, (float)motionY));
        }
    }

    private static boolean hasMotionToWall(LocalPlayer localPlayer, double x, double z) {
        AABB aabb = localPlayer.m_6972_(localPlayer.m_20089_()).m_20393_(localPlayer.m_20182_()).m_82400_(0.01).m_82386_(x * 0.1, 0.0, z * 0.1);
        return !localPlayer.m_9236_().m_45772_(aabb);
    }

    private static void wallJump(LocalPlayer localPlayer, double x, double z) {
        double motionY = (double)((LivingEntityAccessor)localPlayer).callGetJumpPower() * 1.1;
        Vec3 vec3 = localPlayer.m_20184_();
        localPlayer.m_20256_(vec3.m_82520_(vec3.f_82479_ - x * 0.11, motionY, vec3.f_82481_ - z * 0.11));
        localPlayer.f_19812_ = true;
        NetworkHandler.CHANNEL.sendToServer((Object)new PlayerJumpPacketC2S(true, false, (float)motionY));
    }

    public static void handlePacket(PlayerClimbPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            climberAmount = packet.climberAmount();
        });
        context.setPacketHandled(true);
    }
}

