/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.renderer;

import java.util.Hashtable;
import java.util.List;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.confluence.terra_curio.client.renderer.AchievementDisplay;
import org.confluence.terra_curio.misc.ModSoundEvents;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AchievementToast
implements Toast {
    private static final Hashtable<ResourceLocation, Toast> ACHIEVEMENTS = new Hashtable();
    private final ResourceLocation icon;
    private final AchievementDisplay display;
    public boolean playedSound;

    public AchievementToast(ResourceLocation icon, AchievementDisplay display) {
        this.icon = icon;
        this.display = display;
        this.playedSound = false;
    }

    public int m_94899_() {
        return 64;
    }

    public int iconSize() {
        return 64;
    }

    public int iconBorder() {
        return 4;
    }

    @NotNull
    public Toast.Visibility m_7172_(@NotNull GuiGraphics pGuiGraphics, @NotNull ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        Font font = pToastComponent.m_94929_().f_91062_;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 80.0f, 0.0f);
        pGuiGraphics.m_280218_(f_94893_, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        this.renderTitle(pGuiGraphics, pTimeSinceLastVisible, font);
        this.renderDescription(pGuiGraphics, font);
        this.renderIcon(pGuiGraphics, this.iconSize(), this.iconBorder());
        pGuiGraphics.m_280168_().m_85849_();
        this.playSound(pToastComponent, pTimeSinceLastVisible);
        return (double)pTimeSinceLastVisible >= 5000.0 * pToastComponent.m_264542_() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    private void playSound(@NotNull ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        if (!this.playedSound && pTimeSinceLastVisible > 0L) {
            this.playedSound = true;
            if (this.display.frame() == FrameType.CHALLENGE) {
                pToastComponent.m_94929_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ModSoundEvents.ACHIEVEMENTS.get()), (float)1.0f, (float)1.0f));
            }
        }
    }

    private void renderDescription(@NotNull GuiGraphics pGuiGraphics, Font font) {
        List list = font.m_92923_((FormattedText)this.display.description(), 141);
        if (list.size() == 1) {
            pGuiGraphics.m_280649_(font, (FormattedCharSequence)list.get(0), 8, 44, 0, false);
        } else {
            int l = 48 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                pGuiGraphics.m_280649_(font, formattedcharsequence, 8, l, 0, false);
                l += 9;
            }
        }
    }

    private void renderIcon(@NotNull GuiGraphics pGuiGraphics, int size, int border) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)border, (float)border, 0.0f);
        float scale = (float)(16 + border + border) / (float)size;
        pGuiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        pGuiGraphics.m_280163_(this.icon, 0, 0, 0.0f, 0.0f, size, size, size, size);
        pGuiGraphics.m_280168_().m_85849_();
    }

    private void renderTitle(@NotNull GuiGraphics pGuiGraphics, long pTimeSinceLastVisible, Font font) {
        int i;
        List list = font.m_92923_((FormattedText)this.display.title(), 125);
        int n = i = this.display.frame() == FrameType.CHALLENGE ? 0xFF88FF : 0xFFFF00;
        if (list.size() == 1) {
            pGuiGraphics.m_280614_(font, this.display.frame().m_15553_(), 30, 7, i | 0xFF000000, false);
            pGuiGraphics.m_280649_(font, (FormattedCharSequence)list.get(0), 30, 18, -1, false);
        } else if (pTimeSinceLastVisible < 1500L) {
            int k = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(1500L - pTimeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            pGuiGraphics.m_280614_(font, this.display.frame().m_15553_(), 30, 11, i | k, false);
        } else {
            int i1 = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(pTimeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int l = 16 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                pGuiGraphics.m_280649_(font, formattedcharsequence, 30, l, 0xFFFFFF | i1, false);
                l += 9;
            }
        }
    }

    public static void registerToast(ResourceLocation advancement, Toast toast) {
        ACHIEVEMENTS.put(advancement, toast);
    }

    public static void registerToast(String namespace, String path) {
        AchievementToast.registerToast(new ResourceLocation(namespace, path), new AchievementToast(new ResourceLocation(namespace, "textures/achievement/" + path + ".png"), new AchievementDisplay(FrameType.CHALLENGE, (Component)Component.m_237115_((String)("achievements." + namespace + "." + path + ".title")), (Component)Component.m_237115_((String)("achievements." + namespace + "." + path + ".description")))));
    }

    public static void registerToast(String path) {
        AchievementToast.registerToast("terra_curio", path);
    }

    public static Toast getToast(ResourceLocation advancement) {
        return ACHIEVEMENTS.get(advancement);
    }

    public static void removeToast(ResourceLocation advancement) {
        ACHIEVEMENTS.remove(advancement);
    }

    public static void clearToast() {
        ACHIEVEMENTS.clear();
    }
}

