/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.capability.ability.AbilityProvider;
import org.confluence.terra_curio.capability.ability.PlayerAbility;
import org.confluence.terra_curio.item.curio.combat.FrozenTurtleShell;
import org.confluence.terra_curio.item.curio.combat.IFireAttack;
import org.confluence.terra_curio.item.curio.combat.IHoneycomb;
import org.confluence.terra_curio.item.curio.combat.ILavaHurtReduce;
import org.confluence.terra_curio.item.curio.combat.IStarCloak;
import org.confluence.terra_curio.item.curio.combat.MoltenQuiver;
import org.confluence.terra_curio.item.curio.combat.PaladinsShield;
import org.confluence.terra_curio.item.curio.combat.PanicNecklace;
import org.confluence.terra_curio.item.curio.expert.BrainOfConfusion;
import org.confluence.terra_curio.item.curio.expert.WormScarf;
import org.confluence.terra_curio.item.curio.informational.IDPSMeter;
import org.confluence.terra_curio.item.curio.movement.IFallResistance;
import org.confluence.terra_curio.misc.ModAttributes;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.EntityKilledPacketS2C;
import org.confluence.terra_curio.network.s2c.InfoCurioCheckPacketS2C;

@Mod.EventBusSubscriber(modid="terra_curio", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEvents {
    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            if (PlayerAbility.of(living).isPresent()) {
                return;
            }
            event.addCapability(TerraCurio.asResource("ability"), (ICapabilityProvider)new AbilityProvider());
        }
    }

    @SubscribeEvent
    public static void livingDamage(LivingDamageEvent event) {
        LivingEntity victim = event.getEntity();
        if (victim.m_9236_().f_46443_) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_276093_(DamageTypes.f_268724_) || damageSource.m_276093_(DamageTypes.f_286979_)) {
            return;
        }
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            AttributeInstance instance;
            LivingEntity attacker = (LivingEntity)entity;
            IFireAttack.apply(victim, attacker);
            if (!ModAttributes.hasCustomAttribute((Attribute)ModAttributes.CRIT_CHANCE.get()) && (instance = attacker.m_21051_((Attribute)ModAttributes.CRIT_CHANCE.get())) != null && (double)attacker.m_217043_().m_188501_() < instance.m_22135_()) {
                event.setAmount(amount * 1.5f);
            }
        }
    }

    @SubscribeEvent
    public static void livingHurt(LivingHurtEvent event) {
        LivingEntity victim = event.getEntity();
        if (victim.m_9236_().f_46443_) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_276093_(DamageTypes.f_268724_) || damageSource.m_276093_(DamageTypes.f_286979_)) {
            return;
        }
        RandomSource random = victim.m_217043_();
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        IHoneycomb.apply(victim, random);
        IStarCloak.apply(victim, random);
        PanicNecklace.apply(victim);
        amount = ModAttributes.applyMagicDamage(damageSource, amount);
        amount = ModAttributes.applyRangedDamage(damageSource, amount);
        amount = PaladinsShield.apply(victim, damageSource, amount);
        amount = FrozenTurtleShell.apply(victim, amount);
        amount = ILavaHurtReduce.apply(victim, damageSource, amount);
        amount = IFallResistance.apply(victim, damageSource, amount);
        amount = WormScarf.apply(victim, amount);
        amount = BrainOfConfusion.apply(victim, random, amount);
        if (((Boolean)ModConfigs.RANDOM_ATTACK_DAMAGE.get()).booleanValue()) {
            amount *= Mth.m_216267_((RandomSource)random, (float)((Double)ModConfigs.RANDOM_ATTACK_DAMAGE_MIN.get()).floatValue(), (float)((Double)ModConfigs.RANDOM_ATTACK_DAMAGE_MAX.get()).floatValue());
        }
        IDPSMeter.sendMsg(amount, damageSource.m_7639_());
        event.setAmount(amount);
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EntityType entityType = living.m_6095_();
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new EntityKilledPacketS2C(serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)entityType)), ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType)));
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity self = event.getEntity();
        if (!(self instanceof Enemy)) {
            return;
        }
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof Player) {
            Player playerO = (Player)livingEntity;
            double range = self.m_21133_(Attributes.f_22277_);
            double rangeSqr = range * range;
            self.m_9236_().m_6907_().stream().filter(player -> player.m_20280_((Entity)self) < rangeSqr && self.m_6779_((LivingEntity)player)).max((playerA, playerB) -> {
                AttributeInstance instanceA = playerA.m_21051_(ModAttributes.getAggro());
                AttributeInstance instanceB = playerB.m_21051_(ModAttributes.getAggro());
                if (instanceA != null && instanceB != null) {
                    return (int)(instanceA.m_22135_() - instanceB.m_22135_());
                }
                return 0;
            }).ifPresent(player -> {
                if (player == playerO) {
                    return;
                }
                AttributeInstance instanceO = playerO.m_21051_(ModAttributes.getAggro());
                AttributeInstance instance = player.m_21051_(ModAttributes.getAggro());
                if (instanceO != null && instance != null && instanceO.m_22135_() < instance.m_22135_()) {
                    event.setNewTarget((LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        ServerLevel level;
        LivingEntity living = event.getEntity();
        ModAttributes.applyPickupRange(living);
        Level level2 = living.m_9236_();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).m_46467_() % 200L == 0L) {
            InfoCurioCheckPacketS2C.sendToOthers(level, living);
        }
    }

    @SubscribeEvent
    public static void entityJoinLevel(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        if (event.loadedFromDisk() || event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ModAttributes.applyToArrow(living, arrow);
            MoltenQuiver.applyToArrow(living, arrow);
        }
    }
}

