/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.event;

import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.confluence.terra_curio.effect.ModEffects;
import org.confluence.terra_curio.effect.neutral.CerebralMindtrickEffect;
import org.confluence.terra_curio.item.curio.CurioItems;
import org.confluence.terra_curio.misc.ModAttributes;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.recipe.AmountIngredient;

@Mod.EventBusSubscriber(modid="terra_curio", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEvents {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandler.register();
            ModConfigs.onLoadCommon();
        });
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> ((CerebralMindtrickEffect)((Object)((Object)ModEffects.CEREBRAL_MINDTRICK.get()))).m_19472_(ModAttributes.getCriticalChance(), "181304C7-2A0A-5D46-D4CF-28DC955532FA", 0.04, AttributeModifier.Operation.ADDITION));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void register(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256913_) {
            for (CurioItems value : CurioItems.values()) {
                ResourceLocation id = value.getValue().getId();
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(new ResourceLocation("confluence", id.m_135815_()), id);
            }
        } else if (event.getRegistryKey() == Registries.f_256728_) {
            for (RegistryObject entry : ModAttributes.ATTRIBUTES.getEntries()) {
                ResourceLocation id = entry.getId();
                ((ForgeRegistry)ForgeRegistries.ATTRIBUTES).addAlias(new ResourceLocation("confluence", id.m_135815_()), id);
            }
        } else if (event.getRegistryKey() == Registries.f_256764_) {
            event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> CraftingHelper.register((ResourceLocation)new ResourceLocation("terra_curio", "amount"), (IIngredientSerializer)AmountIngredient.Serializer.INSTANCE));
        }
    }

    @SubscribeEvent
    public static void modify(EntityAttributeModificationEvent event) {
        ModAttributes.readJsonConfig();
        BiConsumer<EntityType<? extends LivingEntity>, Attribute> add = (arg_0, arg_1) -> ((EntityAttributeModificationEvent)event).add(arg_0, arg_1);
        ModAttributes.registerAttribute((Attribute)ModAttributes.CRIT_CHANCE.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.RANGED_VELOCITY.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.RANGED_DAMAGE.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.DODGE_CHANCE.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.MINING_SPEED.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.AGGRO.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.MAGIC_DAMAGE.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.ARMOR_PASS.get(), add);
        ModAttributes.registerAttribute((Attribute)ModAttributes.PICKUP_RANGE.get(), add);
    }
}

