/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.confluence.terra_curio.capability.ability.AbilityProvider;
import org.confluence.terra_curio.capability.ability.PlayerAbility;
import org.confluence.terra_curio.client.handler.GravitationHandler;
import org.confluence.terra_curio.misc.ModAttributes;
import org.confluence.terra_curio.network.s2c.InfoCurioCheckPacketS2C;
import org.confluence.terra_curio.util.ModUtils;

@Mod.EventBusSubscriber(modid="terra_curio", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class PlayerEvents {
    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            InfoCurioCheckPacketS2C.send(serverPlayer, serverPlayer.m_150109_());
            ModUtils.resetClientPacket(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.m_7578_()) {
            GravitationHandler.unCrouching(event.player);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Player neoPlayer = event.getEntity();
        oldPlayer.revive();
        PlayerAbility.of((LivingEntity)oldPlayer).ifPresent(old -> neoPlayer.getCapability(AbilityProvider.CAPABILITY).ifPresent(neo -> neo.copyFrom((PlayerAbility)old)));
        if (neoPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)neoPlayer;
            ModUtils.resetClientPacket(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (ModAttributes.hasCustomAttribute((Attribute)ModAttributes.MINING_SPEED.get())) {
            return;
        }
        AttributeInstance attributeInstance = event.getEntity().m_21051_((Attribute)ModAttributes.MINING_SPEED.get());
        if (attributeInstance == null) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * (float)attributeInstance.m_22135_());
    }
}

