/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio;

import com.google.common.collect.ImmutableMultimap;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.confluence.terra_curio.capability.ability.PlayerAbility;
import org.confluence.terra_curio.item.curio.combat.IAutoAttack;
import org.confluence.terra_curio.item.curio.combat.IScope;
import org.confluence.terra_curio.item.curio.construction.IRightClickSubtractor;
import org.confluence.terra_curio.item.curio.movement.IMayFly;
import org.confluence.terra_curio.item.curio.movement.IMultiJump;
import org.confluence.terra_curio.item.curio.movement.ITabi;
import org.confluence.terra_curio.item.curio.movement.IWallClimb;
import org.confluence.terra_curio.misc.ModRarity;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.FlushPlayerAbilityPacketS2C;
import org.confluence.terra_curio.util.CuriosUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BaseCurioItem
extends Item
implements ICurioItem {
    protected static final List<Component> EMPTY_TOOLTIP = List.of();
    protected static final ImmutableMultimap<Attribute, AttributeModifier> EMPTY_ATTRIBUTE = ImmutableMultimap.of();

    public BaseCurioItem(Rarity rarity) {
        super(rarity != ModRarity.GRAY && rarity != ModRarity.WHITE ? new Item.Properties().m_41497_(rarity).m_41486_().m_41487_(1) : new Item.Properties().m_41497_(rarity).m_41487_(1));
    }

    public BaseCurioItem() {
        this(ModRarity.BLUE);
    }

    protected void freshAbility(Item item, LivingEntity living) {
        PlayerAbility.of(living).ifPresent(playerAbility -> playerAbility.flushAbility(living));
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new FlushPlayerAbilityPacketS2C(true));
            if (item instanceof IMayFly) {
                IMayFly.sendMsg(serverPlayer);
            }
            if (item instanceof IMultiJump) {
                IMultiJump.sendMsg(serverPlayer);
            }
            if (item instanceof IAutoAttack) {
                IAutoAttack.sendMsg(serverPlayer);
            }
            if (item instanceof IScope) {
                IScope.sendMsg(serverPlayer);
            }
            if (item instanceof IRightClickSubtractor) {
                IRightClickSubtractor.sendMsg(serverPlayer);
            }
            if (item instanceof IWallClimb) {
                IWallClimb.sendMsg(serverPlayer);
            }
            if (item instanceof ITabi) {
                ITabi.sendMsg(serverPlayer);
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        this.freshAbility(stack.m_41720_(), living);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        this.freshAbility(stack.m_41720_(), living);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return this.canEquip(slotContext, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosUtils.noSameCurio(slotContext.entity(), this);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237115_((String)("item.terra_curio." + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this)).m_135815_() + ".tooltip")));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        BaseCurioItem baseCurioItem = this;
        if (baseCurioItem instanceof ModRarity.Special) {
            ModRarity.Special special = (ModRarity.Special)((Object)baseCurioItem);
            return special.withColor(this.m_5671_(itemStack));
        }
        return super.m_7626_(itemStack);
    }

    public Component[] getInformation() {
        return new Component[0];
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.m_6589_();
    }
}

