/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.combat;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.terra_curio.client.handler.ClientPacketHandler;
import org.confluence.terra_curio.integration.bettercombat.BetterCombatHelper;
import org.confluence.terra_curio.mixin.client.MinecraftAccessor;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.AutoAttackPacketS2C;
import org.confluence.terra_curio.util.CuriosUtils;

public interface IAutoAttack {
    public static final Component TOOLTIP = Component.m_237115_((String)"curios.tooltip.auto_attack");

    public static void sendMsg(ServerPlayer serverPlayer) {
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new AutoAttackPacketS2C(CuriosUtils.hasCurio((LivingEntity)serverPlayer, IAutoAttack.class)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void apply(Minecraft minecraft, LocalPlayer localPlayer) {
        ItemStack itemStack;
        if (minecraft.f_91072_ == null || minecraft.f_91072_.m_105296_()) {
            return;
        }
        if (BetterCombatHelper.isLoaded() && BetterCombatHelper.hasWeaponAttributes(itemStack = localPlayer.m_21120_(InteractionHand.MAIN_HAND))) {
            return;
        }
        if (ClientPacketHandler.couldAutoAttack() && minecraft.f_91066_.f_92096_.m_90857_()) {
            if (localPlayer.m_36403_(0.5f) < 1.0f) {
                return;
            }
            MinecraftAccessor accessor = (MinecraftAccessor)minecraft;
            if (accessor.getMissTime() > 0) {
                accessor.setMissTime(0);
            }
            double reach = Math.max(localPlayer.getEntityReach(), localPlayer.getBlockReach());
            Vec3 from = localPlayer.m_20299_(1.0f);
            Vec3 viewVector = localPlayer.m_20252_(1.0f);
            Vec3 to = from.m_82520_(viewVector.f_82479_ * reach, viewVector.f_82480_ * reach, viewVector.f_82481_ * reach);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)localPlayer, (Vec3)from, (Vec3)to, (AABB)new AABB(from, to), entity -> !entity.m_5833_() && entity.m_6087_(), (double)reach);
            if (entityhitresult != null && minecraft.f_91072_ != null) {
                minecraft.f_91072_.m_105223_((Player)localPlayer, entityhitresult.m_82443_());
            }
            localPlayer.m_36334_();
            localPlayer.m_6674_(InteractionHand.MAIN_HAND);
        }
    }
}

