/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.combat;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.confluence.terra_curio.datagen.limit.CustomName;
import org.confluence.terra_curio.effect.ModEffects;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.misc.ModRarity;
import top.theillusivec4.curios.api.SlotContext;

public class PaladinsShield
extends BaseCurioItem
implements CustomName {
    public static final UUID ARMOR_UUID = UUID.fromString("276CFD23-08F7-50D5-8797-C7F4E1DAD96E");
    public static final UUID RESISTANCE_UUID = UUID.fromString("E4816CB8-0453-3050-70A6-2D0075E84FC5");
    private static ImmutableMultimap<Attribute, AttributeModifier> ATTRIBUTE;

    public PaladinsShield(Rarity rarity) {
        super(rarity);
    }

    public PaladinsShield() {
        super(ModRarity.YELLOW);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (ATTRIBUTE == null) {
            ATTRIBUTE = ImmutableMultimap.of((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Paladins Shield", (double)((Integer)ModConfigs.PALADINS_SHIELD_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22278_, (Object)new AttributeModifier(RESISTANCE_UUID, "Paladins Shield", ((Double)ModConfigs.PALADINS_SHIELD_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        return ATTRIBUTE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)livingEntity).m_9236_().m_46467_() % 200L == 0L) {
            Team team = serverPlayer.m_5647_();
            for (Player player : serverPlayer.m_9236_().m_6907_()) {
                if (player.m_5647_() != team) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.PALADINS_SHIELD.get(), 600, player == serverPlayer ? 1 : 0));
            }
        }
    }

    public static float apply(LivingEntity living, DamageSource damageSource, float amount) {
        ServerPlayer serverPlayer;
        if (living instanceof ServerPlayer && !PaladinsShield.isOwner((LivingEntity)(serverPlayer = (ServerPlayer)living))) {
            MutableFloat atomic = new MutableFloat(amount);
            Team team = serverPlayer.m_5647_();
            serverPlayer.m_9236_().m_6907_().stream().filter(player -> player != serverPlayer && player != damageSource.m_7639_() && player.m_5647_() == team && player.m_21223_() / player.m_21233_() > 0.25f && PaladinsShield.isOwner((LivingEntity)player) && player.m_20280_((Entity)serverPlayer) < 1024.0).min((playerA, playerB) -> (int)(playerA.m_20280_((Entity)serverPlayer) - playerB.m_20280_((Entity)serverPlayer))).ifPresent(player -> {
                float damage = amount * 0.25f;
                player.m_6469_(living.m_269291_().m_269075_((Player)serverPlayer), damage);
                atomic.subtract(damage);
            });
            return atomic.getValue().floatValue();
        }
        return amount;
    }

    public static boolean isOwner(LivingEntity living) {
        MobEffectInstance effect = living.m_21124_((MobEffect)ModEffects.PALADINS_SHIELD.get());
        return effect != null && effect.m_19564_() != 0;
    }

    @Override
    public String getGenName() {
        return "Paladin's Shield";
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.terra_curio.paladins_shield.info")};
    }
}

