/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.combat;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.confluence.terra_curio.effect.ModEffects;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.misc.ModAttributes;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.misc.ModRarity;
import top.theillusivec4.curios.api.SlotContext;

public class SunStone
extends BaseCurioItem {
    public static final UUID ATTACK_SPEED_UUID = UUID.fromString("6B2CFC65-3C84-7C1F-69D8-7B37556578E0");
    public static final UUID DAMAGE_UUID = UUID.fromString("56A08AD3-ADA1-F838-E09C-28B08935F5C2");
    public static final UUID ARMOR_UUID = UUID.fromString("7E929677-A019-1C19-1A2C-36A07268A66B");
    public static final UUID CRIT_UUID = UUID.fromString("840A63CB-F274-75C1-09B1-BC8092B076F4");
    public static final UUID MINING_UUID = UUID.fromString("B599894C-1157-3875-C28C-E4F0681F04E9");
    public static final UUID RANGED_UUID = UUID.fromString("171921EE-AB4F-E630-D69E-BB31E17A22C8");
    public static final UUID MAGIC_UUID = UUID.fromString("B9A4443F-E08B-19CD-0EBD-679F5267CB14");
    private static ImmutableMultimap<Attribute, AttributeModifier> ATTRIBUTES;

    public SunStone() {
        super(ModRarity.LIME);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LivingEntity living;
        if (ATTRIBUTES == null) {
            ATTRIBUTES = ImmutableMultimap.builder().put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ATTACK_SPEED_UUID, "Sun Stone", ((Double)ModConfigs.SUN_STONE_SPEED.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)Attributes.f_22281_, (Object)new AttributeModifier(DAMAGE_UUID, "Sun Stone", ((Double)ModConfigs.SUN_STONE_DAMAGE.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Sun Stone", (double)((Integer)ModConfigs.SUN_STONE_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION)).put((Object)ModAttributes.getCriticalChance(), (Object)new AttributeModifier(CRIT_UUID, "Sun Stone", ((Double)ModConfigs.SUN_STONE_CRITICAL_CHANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION)).put((Object)ModAttributes.getMiningSpeed(), (Object)new AttributeModifier(MINING_UUID, "Sun Stone", ((Double)ModConfigs.SUN_STONE_MINING.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)ModAttributes.getRangedDamage(), (Object)new AttributeModifier(RANGED_UUID, "Sun Stone", ((Double)ModConfigs.SUN_STONE_RANGED.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)ModAttributes.getMagicDamage(), (Object)new AttributeModifier(MAGIC_UUID, "Sun Stone", ((Double)ModConfigs.SUN_STONE_MAGIC.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL)).build();
        }
        if ((living = slotContext.entity()) == null) {
            return EMPTY_ATTRIBUTE;
        }
        return living.m_9236_().m_46468_() % 24000L < 12000L ? ATTRIBUTES : EMPTY_ATTRIBUTE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        if (living.m_9236_().m_46468_() % 24000L > 12000L) {
            return;
        }
        ModEffects.healPerSecond(living, 2.0f);
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.terra_curio.sun_stone.info")};
    }
}

