/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.datadriven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.datagen.limit.CustomModel;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.item.curio.combat.IInvulnerableTime;
import org.confluence.terra_curio.item.curio.construction.IBreakSpeedBonus;
import org.confluence.terra_curio.item.curio.datadriven.DataDrivenAttributeInfo;
import org.confluence.terra_curio.item.curio.datadriven.DataDrivenClassLoader;
import org.confluence.terra_curio.item.curio.datadriven.DataDrivenCurioInfo;
import org.confluence.terra_curio.item.curio.datadriven.ErrorDumpedCurio;
import org.confluence.terra_curio.item.curio.movement.IFallResistance;
import org.confluence.terra_curio.item.curio.movement.IJumpBoost;
import org.confluence.terra_curio.item.curio.movement.IMayFly;
import org.confluence.terra_curio.item.curio.movement.IMultiJump;
import org.confluence.terra_curio.item.curio.movement.IOneTimeJump;
import org.confluence.terra_curio.misc.ModRarity;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class DataDrivenCurioGenerator {
    private static final String BASE_CURIO_ITEM = "org/terra_curio/terra_curio/item/curio/BaseCurioItem";
    private final Map<Class<?>, Number[]> classMap;
    public final Class<?> dumped;

    public DataDrivenCurioGenerator(DataDrivenCurioInfo info) {
        this.classMap = info.classMap();
        HashSet interfaces = new HashSet(this.classMap.keySet());
        interfaces.add(CustomModel.class);
        String rarity = info.rarity().toUpperCase();
        if ("EXPERT".equals(rarity)) {
            interfaces.add(ModRarity.Expert.class);
        } else if ("MASTER".equals(rarity)) {
            interfaces.add(ModRarity.Master.class);
        }
        String className = "DataDrivenCurio$" + Arrays.stream(info.id().split("_")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase()).collect(Collectors.joining());
        this.dumped = new DataDrivenClassLoader(TerraCurio.class.getClassLoader()).defineClass(className, this.create(className, rarity, info.tooltips(), info.infos(), interfaces));
    }

    private byte[] create(String className, String rarity, List<String> tooltips, ArrayList<DataDrivenAttributeInfo> infos, Set<Class<?>> interfaces) {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(61, 33, className, null, BASE_CURIO_ITEM, (String[])interfaces.stream().map(DataDrivenCurioGenerator::getName).toArray(String[]::new));
        if (!infos.isEmpty()) {
            cw.visitInnerClass("com/google/common/collect/ImmutableMultimap$Builder", "com/google/common/collect/ImmutableMultimap", "Builder", 9);
            cw.visitInnerClass("net/minecraft/world/entity/ai/attributes/AttributeModifier$Operation", "net/minecraft/world/entity/ai/attributes/AttributeModifier", "Operation", 16409);
            FieldVisitor fv = cw.visitField(26, "ATTRIBUTE", "Lcom/google/common/collect/ImmutableMultimap;", "Lcom/google/common/collect/ImmutableMultimap<Lnet/minecraft/world/entity/ai/attributes/Attribute;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;>;", null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "org/terra_curio/terra_curio/misc/ModRarity", rarity, "Lnet/minecraft/world/item/Rarity;");
        mv.visitMethodInsn(183, BASE_CURIO_ITEM, "<init>", "(Lnet/minecraft/world/item/Rarity;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        for (Class<?> clazz : interfaces) {
            Number[] numbers;
            if (clazz == IInvulnerableTime.class) {
                this.intValue(cw, "getTime", clazz);
                continue;
            }
            if (clazz == IBreakSpeedBonus.class) {
                this.floatValue(cw, "getBreakBonus", clazz);
                continue;
            }
            if (clazz == IFallResistance.class) {
                this.intValue(cw, "getFallResistance", clazz);
                continue;
            }
            if (clazz == IJumpBoost.class) {
                this.doubleValue(cw, "getBoost", clazz);
                continue;
            }
            if (clazz == IMayFly.class) {
                numbers = this.classMap.get(clazz);
                this.intValue(cw, "getFlyTicks", numbers[0].intValue());
                this.doubleValue(cw, "getFlySpeed", numbers[1].doubleValue());
                continue;
            }
            if (clazz == IMultiJump.class) {
                this.doubleValue(cw, "getJumpSpeed", clazz);
                continue;
            }
            if (clazz != IOneTimeJump.class) continue;
            numbers = this.classMap.get(clazz);
            this.intValue(cw, "getJumpTicks", numbers[0].intValue());
            this.doubleValue(cw, "getJumpSpeed", numbers[1].doubleValue());
        }
        if (!tooltips.isEmpty()) {
            this.appendTooltip(cw, tooltips);
        }
        if (!infos.isEmpty()) {
            this.appendAttribute(cw, className);
            this.clinit(cw, className, infos);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void intValue(ClassWriter cw, String methodName, Class<?> clazz) {
        this.intValue(cw, methodName, this.classMap.get(clazz)[0].intValue());
    }

    private void intValue(ClassWriter cw, String methodName, int value) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()I", null, null);
        mv.visitCode();
        mv.visitIntInsn(17, value);
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void doubleValue(ClassWriter cw, String methodName, Class<?> clazz) {
        this.doubleValue(cw, methodName, this.classMap.get(clazz)[0].doubleValue());
    }

    private void doubleValue(ClassWriter cw, String methodName, double value) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()D", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)value);
        mv.visitInsn(175);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void floatValue(ClassWriter cw, String methodName, Class<?> clazz) {
        this.floatValue(cw, methodName, this.classMap.get(clazz)[0].floatValue());
    }

    private void floatValue(ClassWriter cw, String methodName, float value) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()F", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)Float.valueOf(value));
        mv.visitInsn(174);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void appendTooltip(ClassWriter cw, List<String> tooltips) {
        MethodVisitor mv = cw.visitMethod(1, "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List<Lnet/minecraft/network/chat/Component;>;Lnet/minecraft/world/item/TooltipFlag;)V", null);
        mv.visitCode();
        for (String tooltip : tooltips) {
            mv.visitVarInsn(25, 3);
            mv.visitLdcInsn((Object)tooltip);
            mv.visitMethodInsn(184, "net/minecraft/network/chat/Component", "translatable", "(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", true);
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 5);
        mv.visitEnd();
    }

    private void appendAttribute(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, "getAttributeModifiers", "(Ltop/theillusivec4/curios/api/SlotContext;Ljava/util/UUID;Lnet/minecraft/world/item/ItemStack;)Lcom/google/common/collect/Multimap;", "(Ltop/theillusivec4/curios/api/SlotContext;Ljava/util/UUID;Lnet/minecraft/world/item/ItemStack;)Lcom/google/common/collect/Multimap<Lnet/minecraft/world/entity/ai/attributes/Attribute;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;>;", null);
        mv.visitCode();
        mv.visitFieldInsn(178, className, "ATTRIBUTE", "Lcom/google/common/collect/ImmutableMultimap;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 4);
        mv.visitEnd();
    }

    private void clinit(ClassWriter cw, String className, List<DataDrivenAttributeInfo> infos) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, "com/google/common/collect/ImmutableMultimap", "builder", "()Lcom/google/common/collect/ImmutableMultimap$Builder;", false);
        for (DataDrivenAttributeInfo info : infos) {
            mv.visitFieldInsn(178, "net/minecraftforge/registries/ForgeRegistries", "ATTRIBUTES", "Lnet/minecraftforge/registries/IForgeRegistry;");
            mv.visitTypeInsn(187, "net/minecraft/resources/ResourceLocation");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)info.namespace());
            mv.visitLdcInsn((Object)info.path());
            mv.visitMethodInsn(183, "net/minecraft/resources/ResourceLocation", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", false);
            mv.visitMethodInsn(185, "net/minecraftforge/registries/IForgeRegistry", "getValue", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;", true);
            mv.visitTypeInsn(192, "net/minecraft/world/entity/ai/attributes/Attribute");
            mv.visitTypeInsn(187, "net/minecraft/world/entity/ai/attributes/AttributeModifier");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)info.uuid());
            mv.visitMethodInsn(184, "java/util/UUID", "fromString", "(Ljava/lang/String;)Ljava/util/UUID;", false);
            mv.visitLdcInsn((Object)info.name());
            mv.visitLdcInsn((Object)info.value());
            mv.visitFieldInsn(178, "net/minecraft/world/entity/ai/attributes/AttributeModifier$Operation", info.operation(), "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;");
            mv.visitMethodInsn(183, "net/minecraft/world/entity/ai/attributes/AttributeModifier", "<init>", "(Ljava/util/UUID;Ljava/lang/String;DLnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;)V", false);
            mv.visitMethodInsn(182, "com/google/common/collect/ImmutableMultimap$Builder", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableMultimap$Builder;", false);
        }
        mv.visitMethodInsn(182, "com/google/common/collect/ImmutableMultimap$Builder", "build", "()Lcom/google/common/collect/ImmutableMultimap;", false);
        mv.visitFieldInsn(179, className, "ATTRIBUTE", "Lcom/google/common/collect/ImmutableMultimap;");
        mv.visitInsn(177);
        mv.visitMaxs(9, 0);
        mv.visitEnd();
    }

    public BaseCurioItem newInstance() {
        try {
            return (BaseCurioItem)((Object)this.dumped.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ErrorDumpedCurio();
        }
    }

    private static String getName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }
}

