/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.datadriven;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.GsonHelper;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.item.curio.ILavaImmune;
import org.confluence.terra_curio.item.curio.combat.IAutoAttack;
import org.confluence.terra_curio.item.curio.combat.IFireAttack;
import org.confluence.terra_curio.item.curio.combat.IFireImmune;
import org.confluence.terra_curio.item.curio.combat.IHoneycomb;
import org.confluence.terra_curio.item.curio.combat.IInvulnerableTime;
import org.confluence.terra_curio.item.curio.combat.ILavaHurtReduce;
import org.confluence.terra_curio.item.curio.combat.IMagicQuiver;
import org.confluence.terra_curio.item.curio.combat.IScope;
import org.confluence.terra_curio.item.curio.combat.IStarCloak;
import org.confluence.terra_curio.item.curio.construction.IBreakSpeedBonus;
import org.confluence.terra_curio.item.curio.datadriven.DataDrivenAttributeInfo;
import org.confluence.terra_curio.item.curio.movement.IFallResistance;
import org.confluence.terra_curio.item.curio.movement.IJumpBoost;
import org.confluence.terra_curio.item.curio.movement.IMayFly;
import org.confluence.terra_curio.item.curio.movement.IWallClimb;

public record DataDrivenCurioInfo(String id, String rarity, List<String> tooltips, String slot, ArrayList<DataDrivenAttributeInfo> infos, Map<Class<?>, Number[]> classMap) {
    private static final ArrayList<DataDrivenCurioInfo> INFOS = new ArrayList();
    private static final Hashtable<String, Class<?>> MAP = new Hashtable();

    public static ArrayList<DataDrivenCurioInfo> generatingInfos() {
        Path path = TerraCurio.CONFIG_PATH.resolve("curio.json");
        if (Files.notExists(path, new LinkOption[0])) {
            return new ArrayList<DataDrivenCurioInfo>();
        }
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)JsonParser.parseReader((Reader)new InputStreamReader(inputStream)), (String)"data_driven");
            for (Map.Entry entry : jsonObject.entrySet()) {
                String id = (String)entry.getKey();
                JsonObject context = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)"context");
                String rarity = GsonHelper.m_13851_((JsonObject)context, (String)"rarity", (String)"WHITE").toUpperCase();
                ArrayList<String> tooltips = new ArrayList<String>();
                GsonHelper.m_13832_((JsonObject)context, (String)"tooltips", (JsonArray)new JsonArray()).forEach(jsonElement -> tooltips.add(GsonHelper.m_13805_((JsonElement)jsonElement, (String)"tooltip")));
                String slot = GsonHelper.m_13851_((JsonObject)context, (String)"slot", (String)"curio");
                ArrayList<DataDrivenAttributeInfo> infos = new ArrayList<DataDrivenAttributeInfo>();
                for (Map.Entry entry1 : GsonHelper.m_13841_((JsonObject)context, (String)"attributes", (JsonObject)new JsonObject()).entrySet()) {
                    ResourceLocation location = new ResourceLocation((String)entry1.getKey());
                    JsonObject attribute = GsonHelper.m_13918_((JsonElement)((JsonElement)entry1.getValue()), (String)"attribute");
                    String uuid = GsonHelper.m_13851_((JsonObject)attribute, (String)"uuid", (String)UUID.nameUUIDFromBytes((id + infos.size()).getBytes()).toString());
                    String name = GsonHelper.m_13851_((JsonObject)attribute, (String)"name", (String)id);
                    double value = GsonHelper.m_144742_((JsonObject)attribute, (String)"value", (double)1.0);
                    String operation = GsonHelper.m_13851_((JsonObject)attribute, (String)"operation", (String)"ADDITION").toUpperCase();
                    infos.add(new DataDrivenAttributeInfo(location.m_135827_(), location.m_135815_(), uuid, name, value, operation));
                }
                Hashtable classMap = new Hashtable();
                for (Map.Entry entry1 : GsonHelper.m_13841_((JsonObject)context, (String)"interfaces", (JsonObject)new JsonObject()).entrySet()) {
                    Number[] numbers;
                    Class<?> clazz = MAP.get(entry1.getKey());
                    if (clazz == null) {
                        TerraCurio.LOGGER.warn("Unknown interface: {}", entry1.getKey());
                        continue;
                    }
                    JsonElement value = (JsonElement)entry1.getValue();
                    if (value.isJsonPrimitive()) {
                        numbers = new Number[]{value.getAsNumber()};
                    } else if (value.isJsonArray()) {
                        JsonArray values = GsonHelper.m_13924_((JsonElement)value, (String)"values");
                        numbers = new Number[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            numbers[i] = values.get(i).getAsJsonPrimitive().getAsNumber();
                        }
                    } else {
                        numbers = new Number[]{};
                    }
                    classMap.put(clazz, numbers);
                }
                INFOS.add(new DataDrivenCurioInfo(id, rarity, tooltips, slot, infos, classMap));
            }
        }
        catch (Exception e) {
            TerraCurio.LOGGER.error(e.getMessage());
        }
        return INFOS;
    }

    public static void bindTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> map) {
        INFOS.forEach(info -> {
            List list = map.computeIfAbsent(new ResourceLocation("curios", info.slot), location -> new ArrayList());
            ResourceLocation location2 = TerraCurio.asResource(info.id.toLowerCase());
            if (list.stream().noneMatch(entryWithSource -> entryWithSource.f_216042_().getId().equals((Object)location2))) {
                list.add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)location2), "data_driven"));
            }
        });
    }

    static {
        MAP.put("AutoAttack", IAutoAttack.class);
        MAP.put("FireAttack", IFireAttack.class);
        MAP.put("FireImmune", IFireImmune.class);
        MAP.put("Honeycomb", IHoneycomb.class);
        MAP.put("InvulnerableTime", IInvulnerableTime.class);
        MAP.put("LavaHurtReduce", ILavaHurtReduce.class);
        MAP.put("StarCloak", IStarCloak.class);
        MAP.put("BreakSpeedBonus", IBreakSpeedBonus.class);
        MAP.put("FallResistance", IFallResistance.class);
        MAP.put("JumpBoost", IJumpBoost.class);
        MAP.put("MayFly", IMayFly.class);
        MAP.put("LavaImmune", ILavaImmune.class);
        MAP.put("MagicQuiver", IMagicQuiver.class);
        MAP.put("Scope", IScope.class);
        MAP.put("WallClimb", IWallClimb.class);
    }
}

