/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.expert;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.misc.ModRarity;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.GravityGlobePacketS2C;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class GravityGlobe
extends BaseCurioItem
implements ModRarity.Expert {
    public GravityGlobe() {
        super(ModRarity.EXPERT);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        GravityGlobe.sendMsg(slotContext.entity(), true);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        GravityGlobe.sendMsg(slotContext.entity(), false);
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.m_237115_((String)"item.terra_curio.gravity_globe.tooltip2"));
    }

    private static void sendMsg(LivingEntity living, boolean has) {
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new GravityGlobePacketS2C(has));
        }
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.terra_curio.gravity_globe.info")};
    }
}

