/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.movement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.terra_curio.client.ClientConfigs;
import org.confluence.terra_curio.client.color.FloatRGB;
import org.confluence.terra_curio.client.handler.ClientPacketHandler;
import org.confluence.terra_curio.client.particle.options.CurrentDustOptions;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.misc.ModSoundEvents;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.c2s.SpeedBootsNBTPacketC2S;
import org.confluence.terra_curio.util.CuriosUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.SlotContext;

public class BaseSpeedBoots
extends BaseCurioItem {
    public static final UUID SPEED_UUID = UUID.fromString("EE6FAFF5-A69D-6101-F82A-93E55A01F65E");
    public static final Component TOOLTIP = Component.m_237115_((String)"curios.tooltip.speed_boots");
    private static final Vector3f COLOR = FloatRGB.fromInteger(0xFFFFFF).toVector();

    public BaseSpeedBoots(Rarity rarity) {
        super(rarity);
    }

    public BaseSpeedBoots() {
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return EMPTY_TOOLTIP;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.speedUp(slotContext, stack.m_41784_(), 1, 40);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        stack.m_41784_().m_128405_("speed", 0);
    }

    protected void speedUp(SlotContext slotContext, CompoundTag nbt, int addition, int max) {
        Player player;
        LivingEntity living = slotContext.entity();
        if (living instanceof Player && (player = (Player)living).m_7578_()) {
            int speed = nbt.m_128451_("speed");
            if (player.f_20902_ > 0.0f) {
                if (player.m_20096_()) {
                    if (ClientPacketHandler.isHasMagiluminescence()) {
                        addition *= 2;
                    }
                    int actually = Math.min(max - speed, addition);
                    int value = speed + actually;
                    if (actually > 0) {
                        NetworkHandler.CHANNEL.sendToServer((Object)new SpeedBootsNBTPacketC2S(slotContext.index(), value));
                    }
                    float ratio = (float)value / (float)max;
                    if (ClientConfigs.playShoesSound && player.m_9236_().m_46467_() % (ratio < 0.5f ? 6L : 4L) == 0L) {
                        player.m_216990_((SoundEvent)ModSoundEvents.SHOES_WALK.get());
                    }
                }
                if (ClientConfigs.showShoesParticle) {
                    this.spawnParticles(player.m_9236_(), player.m_20182_());
                }
            } else if (speed != 0) {
                NetworkHandler.CHANNEL.sendToServer((Object)new SpeedBootsNBTPacketC2S(slotContext.index(), 0));
            }
        }
    }

    public void spawnParticles(Level level, Vec3 vec3) {
        int rand = level.m_213780_().m_216339_(3, 5);
        double particleRandX = (double)(level.m_213780_().m_216339_(100, 300) - 200) / 1000.0;
        double particleRandY = (double)(level.m_213780_().m_216339_(100, 300) - 200) / 1000.0;
        double particleRandZ = (double)(level.m_213780_().m_216339_(100, 300) - 200) / 1000.0;
        CurrentDustOptions options = new CurrentDustOptions(this.getParticleColorStart(), this.getParticleColorEnd(), 1.2f);
        for (int i = 0; i < rand; ++i) {
            level.m_7106_((ParticleOptions)options, vec3.f_82479_ + particleRandX, vec3.f_82480_ + particleRandY, vec3.f_82481_ + particleRandZ, 0.0, 0.0, 0.0);
        }
    }

    public Vector3f getParticleColorStart() {
        return COLOR;
    }

    public Vector3f getParticleColorEnd() {
        return COLOR;
    }

    protected static AttributeModifier getSpeedModifier(ItemStack stack) {
        return new AttributeModifier(SPEED_UUID, "Speed Boots", (double)stack.m_41784_().m_128451_("speed") * 0.01, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)BaseSpeedBoots.getSpeedModifier(stack));
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosUtils.noSameCurio(slotContext.entity(), BaseSpeedBoots.class);
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        list.add(TOOLTIP);
    }
}

