/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.movement;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.item.curio.movement.IJumpBoost;
import org.confluence.terra_curio.item.curio.movement.IMultiJump;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.misc.ModRarity;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.PlayerJumpPacketS2C;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class BundleOfBalloons
extends BaseCurioItem
implements IJumpBoost {
    public BundleOfBalloons() {
        super(ModRarity.YELLOW);
    }

    @Override
    public double getBoost() {
        return (Double)ModConfigs.BUNDLE_OF_BALLOONS_JUMP_BOOST.get();
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerJumpPacketS2C(-2.0, (Double)ModConfigs.SANDSTORM_IN_A_BALLOON_JUMP_SPEED.get(), (Integer)ModConfigs.SANDSTORM_IN_A_BALLOON_JUMP_TICKS.get(), (Double)ModConfigs.BLIZZARD_IN_A_BALLOON_JUMP_SPEED.get(), (Integer)ModConfigs.BLIZZARD_IN_A_BALLOON_JUMP_TICKS.get(), -2.0, (Double)ModConfigs.CLOUD_IN_A_BALLOON_JUMP_SPEED.get()));
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            IMultiJump.sendMsg(serverPlayer);
        }
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add(IJumpBoost.TOOLTIP);
    }
}

