/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.movement;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.terra_curio.item.curio.movement.BlizzardInABottle;
import org.confluence.terra_curio.item.curio.movement.BundleOfBalloons;
import org.confluence.terra_curio.item.curio.movement.CloudInABottle;
import org.confluence.terra_curio.item.curio.movement.FartInAJar;
import org.confluence.terra_curio.item.curio.movement.SandstormInABottle;
import org.confluence.terra_curio.item.curio.movement.TsunamiInABottle;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.PlayerJumpPacketS2C;
import top.theillusivec4.curios.api.CuriosApi;

public interface IMultiJump {
    public static final Component TOOLTIP = Component.m_237115_((String)"curios.tooltip.multi_jump");

    public double getJumpSpeed();

    public static void sendMsg(ServerPlayer serverPlayer) {
        AtomicDouble fartSpeed = new AtomicDouble(-1.0);
        AtomicDouble sandstormSpeed = new AtomicDouble(-1.0);
        AtomicInteger sandstormTicks = new AtomicInteger();
        AtomicDouble blizzardSpeed = new AtomicDouble(-1.0);
        AtomicInteger blizzardTicks = new AtomicInteger();
        AtomicDouble tsunamiSpeed = new AtomicDouble(-1.0);
        AtomicDouble cloudSpeed = new AtomicDouble(-1.0);
        CuriosApi.getCuriosInventory((LivingEntity)serverPlayer).ifPresent(curiosItemHandler -> {
            IItemHandlerModifiable itemHandlerModifiable = curiosItemHandler.getEquippedCurios();
            for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
                Item curio = itemHandlerModifiable.getStackInSlot(i).m_41720_();
                if (curio instanceof FartInAJar) {
                    FartInAJar fart = (FartInAJar)curio;
                    fartSpeed.set(fart.getJumpSpeed());
                    continue;
                }
                if (curio instanceof SandstormInABottle) {
                    SandstormInABottle sandstorm = (SandstormInABottle)curio;
                    sandstormSpeed.set(sandstorm.getJumpSpeed());
                    sandstormTicks.set(sandstorm.getJumpTicks());
                    continue;
                }
                if (curio instanceof BlizzardInABottle) {
                    BlizzardInABottle blizzard = (BlizzardInABottle)curio;
                    blizzardSpeed.set(blizzard.getJumpSpeed());
                    blizzardTicks.set(blizzard.getJumpTicks());
                    continue;
                }
                if (curio instanceof TsunamiInABottle) {
                    TsunamiInABottle tsunami = (TsunamiInABottle)curio;
                    tsunamiSpeed.set(tsunami.getJumpSpeed());
                    continue;
                }
                if (curio instanceof CloudInABottle) {
                    CloudInABottle cloud = (CloudInABottle)curio;
                    cloudSpeed.set(cloud.getJumpSpeed());
                    continue;
                }
                if (!(curio instanceof BundleOfBalloons)) continue;
                sandstormSpeed.set(((Double)ModConfigs.SANDSTORM_IN_A_BALLOON_JUMP_SPEED.get()).doubleValue());
                sandstormTicks.set((Integer)ModConfigs.SANDSTORM_IN_A_BALLOON_JUMP_TICKS.get());
                blizzardSpeed.set(((Double)ModConfigs.BLIZZARD_IN_A_BALLOON_JUMP_SPEED.get()).doubleValue());
                blizzardTicks.set((Integer)ModConfigs.BLIZZARD_IN_A_BALLOON_JUMP_TICKS.get());
                cloudSpeed.set(((Double)ModConfigs.CLOUD_IN_A_BALLOON_JUMP_SPEED.get()).doubleValue());
            }
        });
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerJumpPacketS2C(fartSpeed.get(), sandstormSpeed.get(), sandstormTicks.get(), blizzardSpeed.get(), blizzardTicks.get(), tsunamiSpeed.get(), cloudSpeed.get()));
    }
}

