/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.movement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.misc.ModConfigs;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.MagiluminescencePacketS2C;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class Magiluminescence
extends BaseCurioItem {
    public static final UUID SPEED_UUID = UUID.fromString("F0E9149C-E146-5D87-A319-A45CE63A2C65");
    private static ImmutableMultimap<Attribute, AttributeModifier> SPEED;

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        Magiluminescence.sendMsg(slotContext.entity(), true);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        Magiluminescence.sendMsg(slotContext.entity(), false);
    }

    private static void sendMsg(LivingEntity living, boolean has) {
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MagiluminescencePacketS2C(has));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (SPEED == null) {
            SPEED = ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)new AttributeModifier(SPEED_UUID, "Magiluminescence", ((Double)ModConfigs.MAGILUMINESCENCE_MOVEMENT.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return SPEED;
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237115_((String)"item.terra_curio.magiluminescence.tooltip"));
        list.add((Component)Component.m_237115_((String)"item.terra_curio.magiluminescence.tooltip3"));
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.terra_curio.magiluminescence.info")};
    }
}

