/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.item.curio.movement;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.confluence.terra_curio.entity.StepStoolEntity;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.network.NetworkHandler;
import org.confluence.terra_curio.network.s2c.StepStoolStepPacketS2C;
import org.confluence.terra_curio.util.CuriosUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class StepStool
extends BaseCurioItem {
    public static final Component TOOLTIP = Component.m_237115_((String)"item.terra_curio.step_stool.tooltip");

    public StepStool(Rarity rarity) {
        super(rarity);
    }

    public StepStool() {
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (prevStack.m_41720_() == stack.m_41720_()) {
            return;
        }
        super.onEquip(slotContext, prevStack, stack);
        StepStool.send(slotContext, stack.m_41784_().m_128451_("extraStep") + 1);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Entity entity;
        if (newStack.m_41720_() == stack.m_41720_()) {
            return;
        }
        super.onUnequip(slotContext, newStack, stack);
        StepStool.send(slotContext, 0);
        Level level = slotContext.entity().m_9236_();
        if (!level.f_46443_ && (entity = level.m_6815_(stack.m_41784_().m_128451_("id"))) instanceof StepStoolEntity) {
            StepStoolEntity stepStool = (StepStoolEntity)entity;
            stepStool.setOwner(null);
        }
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosUtils.noSameCurio(slotContext.entity(), StepStool.class);
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        list.add(TOOLTIP);
        if (itemStack.m_41783_() != null) {
            list.add((Component)Component.m_237110_((String)"item.terra_curio.step_stool.tooltip2", (Object[])new Object[]{itemStack.m_41783_().m_128451_("extraStep")}).m_130938_(style -> style.m_131140_(ChatFormatting.BLUE)));
        }
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.terra_curio.step_stool.info")};
    }

    public static void send(SlotContext slotContext, int maxStep) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new StepStoolStepPacketS2C(slotContext.index(), maxStep));
        }
    }
}

