/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.integration.apothic.ApothicHelper;

public final class ModAttributes {
    private static final Hashtable<Attribute, Attribute> MAP = new Hashtable();
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"terra_curio");
    public static final RegistryObject<Attribute> CRIT_CHANCE = ATTRIBUTES.register("crit_chance", () -> new RangedAttribute("attribute.name.generic.critical_chance", 0.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> RANGED_VELOCITY = ATTRIBUTES.register("ranged_velocity", () -> new RangedAttribute("attribute.name.generic.ranged_velocity", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> RANGED_DAMAGE = ATTRIBUTES.register("ranged_damage", () -> new RangedAttribute("attribute.name.generic.ranged_damage", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> DODGE_CHANCE = ATTRIBUTES.register("dodge_chance", () -> new RangedAttribute("attribute.name.generic.dodge_chance", 0.0, 0.0, 1.0).m_22084_(true));
    public static final RegistryObject<Attribute> MINING_SPEED = ATTRIBUTES.register("mining_speed", () -> new RangedAttribute("attribute.name.generic.mining_speed", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> AGGRO = ATTRIBUTES.register("aggro", () -> new RangedAttribute("attribute.name.generic.aggro", 0.0, -10000.0, 10000.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAGIC_DAMAGE = ATTRIBUTES.register("magic_damage", () -> new RangedAttribute("attribute.name.generic.magic_damage", 1.0, 0.0, 10.0).m_22084_(true));
    public static final RegistryObject<Attribute> ARMOR_PASS = ATTRIBUTES.register("armor_pass", () -> new RangedAttribute("attribute.name.generic.armor_pass", 0.0, 0.0, 10000.0).m_22084_(true));
    public static final RegistryObject<Attribute> PICKUP_RANGE = ATTRIBUTES.register("pickup_range", () -> new RangedAttribute("attribute.name.generic.pickup_range", 0.0, 0.0, 64.0).m_22084_(true));

    public static Attribute getCriticalChance() {
        return ModAttributes.getCustomAttribute((Attribute)CRIT_CHANCE.get());
    }

    public static Attribute getRangedVelocity() {
        return ModAttributes.getCustomAttribute((Attribute)RANGED_VELOCITY.get());
    }

    public static Attribute getRangedDamage() {
        return ModAttributes.getCustomAttribute((Attribute)RANGED_DAMAGE.get());
    }

    public static Attribute getDodgeChance() {
        return ModAttributes.getCustomAttribute((Attribute)DODGE_CHANCE.get());
    }

    public static Attribute getMiningSpeed() {
        return ModAttributes.getCustomAttribute((Attribute)MINING_SPEED.get());
    }

    public static Attribute getAggro() {
        return ModAttributes.getCustomAttribute((Attribute)AGGRO.get());
    }

    public static Attribute getMagicDamage() {
        return ModAttributes.getCustomAttribute((Attribute)MAGIC_DAMAGE.get());
    }

    public static Attribute getArmorPass() {
        return ModAttributes.getCustomAttribute((Attribute)ARMOR_PASS.get());
    }

    public static Attribute getPickupRange() {
        return ModAttributes.getCustomAttribute((Attribute)PICKUP_RANGE.get());
    }

    public static Attribute getCustomAttribute(Attribute attribute) {
        Attribute target = MAP.get(attribute);
        if (target == null) {
            return attribute;
        }
        return target;
    }

    public static boolean hasCustomAttribute(Attribute attribute) {
        return MAP.get(attribute) != null;
    }

    public static void registerAttribute(Attribute attribute, BiConsumer<EntityType<? extends LivingEntity>, Attribute> consumer) {
        if (!ModAttributes.hasCustomAttribute(attribute)) {
            consumer.accept((EntityType<? extends LivingEntity>)EntityType.f_20532_, attribute);
        }
    }

    public static void applyToArrow(LivingEntity living, AbstractArrow abstractArrow) {
        AttributeInstance attributeInstance = living.m_21051_(Attributes.f_22282_);
        if (attributeInstance != null) {
            abstractArrow.m_36735_((int)Math.ceil((double)abstractArrow.m_150123_() * (1.0 + attributeInstance.m_22135_())));
        }
        if (!ModAttributes.hasCustomAttribute((Attribute)RANGED_VELOCITY.get()) && (attributeInstance = living.m_21051_((Attribute)RANGED_VELOCITY.get())) != null) {
            abstractArrow.m_20256_(abstractArrow.m_20184_().m_82490_(attributeInstance.m_22135_()));
        }
        if (!abstractArrow.m_36792_() && !ModAttributes.hasCustomAttribute((Attribute)CRIT_CHANCE.get()) && (attributeInstance = living.m_21051_((Attribute)CRIT_CHANCE.get())) != null) {
            abstractArrow.m_36762_((double)living.m_217043_().m_188501_() < attributeInstance.m_22135_());
        }
    }

    public static boolean applyDodge(LivingEntity living) {
        if (ModAttributes.hasCustomAttribute((Attribute)DODGE_CHANCE.get())) {
            return false;
        }
        AttributeInstance attributeInstance = living.m_21051_((Attribute)DODGE_CHANCE.get());
        if (attributeInstance == null) {
            return false;
        }
        return (double)living.m_9236_().f_46441_.m_188501_() < attributeInstance.m_22135_();
    }

    public static float applyRangedDamage(DamageSource damageSource, float amount) {
        Entity entity;
        if (ModAttributes.hasCustomAttribute((Attribute)RANGED_DAMAGE.get())) {
            return amount;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268524_) && (entity = damageSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance attributeInstance = living.m_21051_((Attribute)RANGED_DAMAGE.get());
            if (attributeInstance == null) {
                return amount;
            }
            return amount * (float)attributeInstance.m_22135_();
        }
        return amount;
    }

    public static float applyMagicDamage(DamageSource damageSource, float amount) {
        Entity entity;
        if (ModAttributes.hasCustomAttribute((Attribute)MAGIC_DAMAGE.get())) {
            return amount;
        }
        if ((damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_276093_(DamageTypes.f_268530_)) && (entity = damageSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance attributeInstance = living.m_21051_((Attribute)MAGIC_DAMAGE.get());
            if (attributeInstance == null) {
                return amount;
            }
            return amount * (float)attributeInstance.m_22135_();
        }
        return amount;
    }

    public static void applyPickupRange(LivingEntity living) {
        if (ModAttributes.hasCustomAttribute((Attribute)PICKUP_RANGE.get())) {
            return;
        }
        AttributeInstance attributeInstance = living.m_21051_((Attribute)PICKUP_RANGE.get());
        if (attributeInstance == null) {
            return;
        }
        double range = attributeInstance.m_22135_();
        if (range <= 0.0) {
            return;
        }
        living.m_9236_().m_6443_(ItemEntity.class, new AABB(living.m_20097_()).m_82400_(range), itemEntity -> true).forEach(itemEntity -> {
            if (itemEntity.m_213877_()) {
                return;
            }
            itemEntity.m_246865_(living.m_20182_().m_82492_(itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_()).m_82541_().m_82490_((double)0.05f).m_82520_(0.0, (double)0.04f, 0.0));
            itemEntity.m_6478_(MoverType.SELF, itemEntity.m_20184_());
        });
    }

    public static void readJsonConfig() {
        Map<String, Attribute> available = Map.of("crit_chance", (Attribute)CRIT_CHANCE.get(), "ranged_velocity", (Attribute)RANGED_VELOCITY.get(), "ranged_damage", (Attribute)RANGED_DAMAGE.get(), "dodge_chance", (Attribute)DODGE_CHANCE.get(), "mining_speed", (Attribute)MINING_SPEED.get(), "aggro", (Attribute)AGGRO.get(), "magic_damage", (Attribute)MAGIC_DAMAGE.get(), "armor_pass", (Attribute)ARMOR_PASS.get(), "pickup_range", (Attribute)PICKUP_RANGE.get());
        ApothicHelper.preset(MAP);
        Path path = TerraCurio.CONFIG_PATH.resolve("attributes.json");
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)JsonParser.parseReader((Reader)new InputStreamReader(inputStream)), (String)"replaceable");
            for (Map.Entry entry : jsonObject.entrySet()) {
                ResourceLocation resourceLocation;
                Attribute raw = available.get(entry.getKey());
                if (raw == null || !ForgeRegistries.ATTRIBUTES.containsKey(resourceLocation = new ResourceLocation(((JsonElement)entry.getValue()).getAsString()))) continue;
                MAP.put(raw, (Attribute)ForgeRegistries.ATTRIBUTES.getValue(resourceLocation));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

